#include <exec/exec.h>
#include <dos/dos.h>
#include <proto/exec.h>
#include <proto/dos.h>

#include "ami_probe.h"
#include "mk4_firmware.h"

int cwfloppy_probe_mk3(struct cw_driver *driver, int controller)
{
    struct PCIDevice    *pcicard = NULL; 
    int             err;
    unsigned int        timeout;
    unsigned char       mem[] = { 1,2,4,8,16,32,64,128,255,44,65,3 };
    int             iobase=0;

    pcicard = driver -> controller[ controller ] -> pcicard;
    iobase  = driver -> controller[ controller ] -> io_base;

    driver -> controller[ controller ] -> type = CATWEASEL_TYPE_MK3;

    write_hex(driver->debug_port,(char *)"Controller PCI Catweasel MK3\n",iobase);

#if 1
    PCICARD_OUTBYTE( pcicard,  iobase + 0x0,0xf1 );
    PCICARD_OUTBYTE( pcicard,  iobase + 0x1,0x00 );
    PCICARD_OUTBYTE( pcicard,  iobase + 0x2,0x00 );
    PCICARD_OUTBYTE( pcicard,  iobase + 0x4,0x00 );
    PCICARD_OUTBYTE( pcicard,  iobase + 0x5,0x00 );
    PCICARD_OUTBYTE( pcicard,  iobase + 0x29,0x00 );
    PCICARD_OUTBYTE( pcicard,  iobase + 0x2b,0x00 );
#endif

    return 0;
}

#define EBUSY 1

int cw4_memory_check(struct cwDevUnit *unit, struct IOExtTD *ioreq)
{
    int             err;
    int             timeout;
    int             iobase;
    struct MsgPort  *port;
    unsigned char       mem[] = { 1,2,4,8,16,32,64,128,255,44,65,3 };
    struct PCIDevice    *pcicard = NULL; 

    pcicard = unit -> controller -> pcicard;
    iobase  = unit -> controller -> io_base;
    port        = unit -> driver -> debug_port;

    // check if memory access is working 
    PCICARD_OUTBYTE( pcicard,  iobase + CW_FLOPPY_RESETPOINTER, 0 );

    for(err=0; err!=sizeof(mem); ++err)
        PCICARD_OUTBYTE( pcicard,  iobase + CW_FLOPPY_MEMORY, mem[err] );

    PCICARD_OUTBYTE( pcicard,  iobase + CW_FLOPPY_RESETPOINTER, 0);

    for(err=0; err!=sizeof(mem); ++err)
    {
        if((timeout=PCICARD_INBYTE( pcicard, iobase + CW_FLOPPY_MEMORY)) != mem[err]) 
        {
            write_num(  port,(char *)"memory test failed. Byte ",err);
            write_num(  port,(char *)"should be ",mem[err]);
            write_num(  port,(char *)"but is ",timeout);
            return -EBUSY;
        }
    }
    return 0;
}

int cwfloppy_probe_mk4(struct cw_driver *driver, int controller)
{
    struct PCIDevice    *pcicard = NULL; 
//  struct timerequest  *IO_Timer = driver->ioreq_timer;
    int             err;
    unsigned int        timeout;
    unsigned char       mem[] = { 1,2,4,8,16,32,64,128,255,44,65,3 };
    int             iobase=0;

#if defined(AROS)
#else
    EXEC_CALL DebugPrintF( "Probing for Catweasel Mk4.\n" );
#endif

    pcicard = driver -> controller[ controller ] -> pcicard;
    iobase  = driver -> controller[ controller ] -> io_base;

    driver -> controller[ controller ] -> type = CATWEASEL_TYPE_MK4;

    write_hex(driver->debug_port,(char *)"Controller PCI Catweasel MK4\n",iobase);

    // Initialize PCI bridge 
    PCICARD_OUTBYTE( pcicard,  iobase + 0x0, 0xf1 );
    PCICARD_OUTBYTE( pcicard,  iobase + 0x1,0x00 );
    PCICARD_OUTBYTE( pcicard,  iobase + CW_DATA_DIRECTION, 0xe3 );
    PCICARD_OUTBYTE( pcicard,  iobase + CW_SELECT_BANK, CW_BANK_FLOPPY);
    PCICARD_OUTBYTE( pcicard,  iobase + 0x4, 0x00);
    PCICARD_OUTBYTE( pcicard,  iobase + 0x5, 0x00);
    PCICARD_OUTBYTE( pcicard,  iobase + 0x29, 0x00);
    PCICARD_OUTBYTE( pcicard,  iobase + 0x2b, 0x00);

    // reset FPGA 
    //PCICARD_OUTBYTE( pcicard,  iobase + 0x2, 0xe3 );

#if defined(AROS)
#else
    IExec -> 
#endif    
    Disable();
    PCICARD_OUTBYTE( pcicard, iobase + CW_SELECT_BANK, CW_BANK_RESETFPGA);

#if defined(AROS) 
#else
    driver -> I_DOS -> 
#endif    
    Delay(1);

//  cw_msdelay(IO_Timer,1);
    PCICARD_OUTBYTE( pcicard, iobase + CW_SELECT_BANK,CW_BANK_FLOPPY);

    // upload firmware 
    for(err=0; err!=sizeof(cw_firmware); ++err)
    {
        // set some direction 
        PCICARD_OUTBYTE( pcicard,  iobase + CW_SELECT_BANK, (cw_firmware[err] & 1)?(CW_BANK_FLOPPY+2):CW_BANK_FLOPPY );

        // wait for FPGA 
        timeout=0;
        while(!(PCICARD_INBYTE( pcicard, iobase+7)&8))
        {
//          cw_udelay(IO_Timer,1);
            if(++timeout >= 1000000)
            {
#if defined(AROS)
#else
                IExec -> 
#endif                
                Enable();
                write_txt(driver->debug_port, (char *)"timeout while writing firmware\n");
                return -EBUSY;
            }
        }
        // write byte 
        PCICARD_OUTBYTE( pcicard,  iobase + CW_FLOPPY_JOYDAT, cw_firmware[err] );
    }

#if defined(AROS)
#else
    IExec -> 
#endif    
    Enable();

    write_hex(driver->debug_port,(char *)"CW MEMORY",iobase + CW_FLOPPY_MEMORY);

    // now wait until FPGA really comes alive 
    timeout=0;
    while(PCICARD_INBYTE( pcicard, iobase + CW_FLOPPY_CONTROL) == 10) 
    {
        // cw_msdelay(IO_Timer,1);
#if defined(AROS)
#else
        driver ->I_DOS -> 
#endif        
        Delay(1);
        timeout++; 
    }

/*
    // check if memory access is working 
    PCICARD_OUTBYTE( pcicard,  iobase + CW_FLOPPY_RESETPOINTER, 0 );

    for(err=0; err!=sizeof(mem); ++err)
        PCICARD_OUTBYTE( pcicard,  iobase + CW_FLOPPY_MEMORY, mem[err] );
    
    PCICARD_OUTBYTE( pcicard,  iobase + CW_FLOPPY_RESETPOINTER, 0);

    for(err=0; err!=sizeof(mem); ++err)
    {
        if((timeout=PCICARD_INBYTE( pcicard, iobase + CW_FLOPPY_MEMORY)) != mem[err]) 
        {
            write_num(  driver->debug_port, (char *)"memory test failed. Byte ",err);
            write_num(  driver->debug_port,(char *)"should be ",mem[err]);
            write_num(  driver->debug_port, (char *)"but is ",timeout);
            return -EBUSY;
        }
    }
*/
    PCICARD_OUTBYTE( pcicard,  iobase + CW_SELECT_BANK, CW_BANK_FLOPPY);

#if defined(AROS)
#else
    IExec->DebugPrintF( "Found CW Mk4.\n" );
#endif
    return 0;
}
