#include <stdio.h>
#include <string.h>
#include <exec/devices.h>
#include <proto/exec.h>
#include <proto/dos.h>
#include <proto/timer.h>
#include <clib/exec_protos.h>
#include <interfaces/timer.h>
#include <exec/types.h>
#include <devices/trackdisk.h>
#include <dos/dosextens.h> 

struct TimerIFace *I_Timer;

void *get_devicebase(char *name)
{
	int eq = 0;
	int i = 0;
	struct Node	*node;
	struct Library	*lib;
	struct List	*list;
	struct ExecBase *ebase;
	struct Device 	*ret = NULL;

	ebase = (struct ExecBase *) (*((struct ExecBase **)4));

	list = &ebase -> DeviceList;

	node = list -> lh_Head;

	for (;node -> ln_Succ!=0;node = node -> ln_Succ)
	{
		eq=1;

		for (i=0;((node -> ln_Name[i]!=0)&&(name[i]!=0));i++)
		{
			if (node -> ln_Name[i]!=name[i])	eq = 0;
		}

		if (eq==1)
		{
			ret = (struct Device *) node;
			break;
		}
	}
	return ret;
}


void cw_msdelay(struct TimerIFace *itime,int time)
{
	struct EClockVal get;
	struct EClockVal end;
	unsigned int ts;
	unsigned int tms;
	int cnt = 0;

	ts = itime -> ReadEClock(&get);
	end.ev_hi = get.ev_hi;
	end.ev_lo = get.ev_lo + (ts  * time / 1000);
	if (end.ev_lo<get.ev_lo) end.ev_hi++;

	for(;;)
	{
		itime -> ReadEClock(&get);
		if ((get.ev_hi=end.ev_hi)&&(get.ev_lo>end.ev_lo)) break;
		if ((get.ev_hi>end.ev_hi)&&(get.ev_lo<end.ev_lo)) break;
	}
}

int main(int num_args, char **arg)
{
	int i, ts;
	struct Device *devbase;
	void *ptr;
	struct EClockVal eclock;
	struct EClockVal eclock2;

	if (devbase = get_devicebase("timer.device"))
	{
		printf("Name: %s\n",devbase -> dd_Library.lib_IdString );

		if (I_Timer = (struct TimerIFace *) IExec -> GetInterface( (void *) devbase,"main",1L,NULL))
		{
			IExec -> Disable();
			I_Timer -> ReadEClock ( &eclock );
			usleep(2000);
			ts = I_Timer -> ReadEClock ( &eclock2 );
			IExec -> Enable();

			printf("Usleep() %i\n",eclock2.ev_lo-eclock.ev_lo);

			printf("ts %i\n",ts / 1000);

//--------------------------------------------------------------------------------------------

			IExec -> Disable();
			I_Timer -> ReadEClock ( &eclock );
			I_Timer->MicroDelay(2000);
			ts = I_Timer -> ReadEClock ( &eclock2 );
			IExec -> Enable();

			printf("MicroDelay() %i\n",eclock2.ev_lo-eclock.ev_lo);

			printf("ts %i\n",ts / 1000);

//--------------------------------------------------------------------------------------------

			IExec -> Disable();
			I_Timer -> ReadEClock ( &eclock );
			cw_msdelay(I_Timer,2);
			ts = I_Timer -> ReadEClock ( &eclock2 );
			IExec -> Enable();

			printf("cw_msdelay() %i\n",eclock2.ev_lo-eclock.ev_lo);

			printf("ts %i\n",ts / 1000);


			IExec -> DropInterface( (void *) I_Timer);
		}
	}
}
