
/*
 * Catweasel -- Advanced Floppy Controller
 * Linux device driver
 * Data common to all encoders (header)
 *
 * Copyright (C) 1998-2002 Michael Krause
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef _ENCODER_COMMON_H
#define _ENCODER_COMMON_H

struct cw_codec 
{
    int (*decode)(struct cwDevUnit *drive, int);
    void (*encode)(struct cwDevUnit *drive);
};

void codec_msdos_init();

extern unsigned char threshtab[128];

void
codec_init_threshtab(int,
             const unsigned char *origt);

void put_normal(struct PCIDevice    *pcicard, const unsigned char *mfmenc,int x,int iobase);
void put_precomp(struct PCIDevice *pcicard, const unsigned char *mfmenc,int x,int iobase);

#ifndef NO_PRECOMP

#define PUT(X) putfunc(pcicard,mfmenc,(X),iobase)

#else /* NO_PRECOMP */

#define PUT(X) pcicard->OutByte(iobase,mfmenc[(X)])

#endif /* NO_PRECOMP */

void calc_time(int iobase);

#endif /* _ENCODER_COMMON_H */
