#define CONFIG_PCI

// dummy -> void 
#define __devinitdata

#define LINUX_VERSION_CODE 0x020400
#define LINUX_VERSION 0x020400
#define KERNEL_VERSION(a,b,c) (a*0x10000)+(b*100)+c

#define MAJOR(x) ((x & 0xFF0000) >> 16)
#define MINOR(x) ((x & 0x00FF00) >> 8)

// no need for symbols

#define MODULE_PARM(var_name,str_data) 
#define MODULE_DEVICE_TABLE(pci, id_table)

int	MAJOR_NR;


#define	HZ	1

int		ms_wait = 10;
int		jiffies = 0;

int 	GFP_KERNEL = 0;

enum
{
	READ,
	WRITE,
	FMODE_WRITE
};

enum
{
	ENODEV,
	DEVICE_REQUEST,
	BLKGETSIZE,
	CW_FMTBEG,
	CW_GETPRM,
	CW_FMTTRK,
	CW_FMTEND,
	VERIFY_WRITE,
	EIO,
	EBUSY,
	EINVAL,
	EROFS,
	ENOMEM,
	ENOSYS,
	EFAULT,
	QUEUE_EMPTY,
	RQ_INACTIVE
};


#define	KERN_ERR "AmigaOS error: "
#define	KERN_NOTICE "AmigaOS notice: "


struct JUST_A_TEST
{
	int expires;
	unsigned long data;
	void *function;
};

struct timer_list
{
	int expires;
	unsigned long data;
	void *function;
};

struct inode
{
	int i_rdev;
	int i_size;
};

struct d_inode
{
	struct inode *d_inode;
};

struct file
{
	struct inode	*f_inode;
	struct d_inode	*f_dentry;
	int			f_mode;

};

struct kernel_module 
{
	int	bh;
	int	rq_dev;
	char	*buffer;
	int	cmd;
	int	nr_sectors;
	int	sector;
	int	current_nr_sectors;
	int	rq_status;
};

typedef struct 
{
	int dummy;
} wait_queue_head_t;

struct dummy_device
{
	void (*request_fn) (void);
};

void dummy_printf(char *s) {};



struct kernel_module *CURRENT;

#define kdev_t int

// dummy functions

#define MOD_INC_USE_COUNT ;
#define MOD_DEC_USE_COUNT ;

void *kmalloc(int size, int dummy) { return malloc(size); }
void kfree(void *mem) { free(mem); }

void	*blk_size[1000] ;
void	*blksize_size[1000] ;
struct dummy_device	blk_dev[1000] ;


// Way is this missing?

struct file_operations  
{
	void	*lseek;
	void 	*block_read;
	void	*block_write;
	void	*read_dir_bad;
	void *pool;
	void *cw_ioctl;
	void *mmap;
	void *cw_open;
#if LINUX_VERSION_CODE >= KERNEL_VERSION(2,1,118)
	int	flush;
#endif
	void *release;
	void *fsync;
	void *fasync;
	void	*floppy_change;
	void *revalidate;
};


#define printk printf

void	check_disk_change() {dummy_printf("check_disk_change() \n");};

void	fsync_dev(int i_rdev) {dummy_printf("fsync_dev\n");};


void	sti() {}; // I'm not going to use this one!!!



void	panic() {dummy_printf("	panic()\n");};

int 	buffer_locked(int buffer) { return TRUE; };

void	end_request() {dummy_printf("end_request()\n");};

// Not in use I'm using usleep(msec*1000)

void	init_timer() {};
void	del_timer() {};
void add_timer() {};




int register_blkdev(int MAJOR_NR, char *name, void *bops)
{ return FALSE; }

int	unregister_blkdev(int MAJOR_NR,char *name) 
{ return FALSE; };

void block_fsync( void ) {};
void block_read( void ) {};
void block_write( void ) {};


// ----


void save_flags() {dummy_printf("save_flags()\n");};
void cli() {dummy_printf("cli()\n");};
void sleep_on() {dummy_printf("sleep_on()\n");};
void restore_flags() {dummy_printf("restore_flags()\n");};
void wake_up() { dummy_printf("wake_up()"); };
void put_fs_long() {dummy_printf("7");};

void invalidate_inodes() {dummy_printf("8");};
void invalidate_buffers() {dummy_printf("9");};

struct super_block *get_super(int a) { return NULL; } ;

//	error = verify_area(VERIFY_WRITE, (void *)arg, sizeof(long));

int verify_area(int mode, void *arg, int size) {};

void memcpy_tofs() { dummy_printf("memcpy_tofs\n"); };

int _IOC_DIR(int cmd) { return cmd; };
int _IOC_TYPE(int cmd) { return cmd; };
int _IOC_NR(int cmd) { return cmd; };
int _IOC_SIZE(int cmd) { return cmd; };

struct block_device_operations
{
	int (*open) (struct inode *, struct file *); 
	int (*release) (struct inode *, struct file *); 
	int (*ioctl) (struct inode *, struct file *, unsigned, unsigned long); 
	int (*check_media_change) (kdev_t); 
	int (*revalidate) (kdev_t);
};

typedef struct
{
	int dummy;

} request_queue_t;

struct pci_device_id 
{
	int	vendor;
	int	device;
	int 	subvendor;
	int 	subdevice;
};

struct pci_driver 
{
	char				*name;
	struct pci_device_id	*id_table;
	int				(*probe) (struct pci_dev *pcidev, const struct pci_device_id *pciid);
};

struct pci_dev
{
	struct PCIResourceRange *io_range;
	unsigned int io_base_address;
	struct PCIDevice *device;
};

	struct PCIDevice *my_cw_device;

// --- PCI

void init_waitqueue_head() {};

int pci_enable_device(struct pci_dev *pcidev) 
{
	return !pcidev -> device -> Lock(PCI_LOCK_SHARED);
}

void	pci_disable_device(struct pci_dev *pcidev)
{
	// maybe the device do not exist or is not locked?
	if (pcidev -> device)
	{
		my_cw_device -> Unlock();
//		pcidev -> device -> Unlock();
	}
	else
	{
		printf("device do not exist\n");
	}
}


/*
 * linux uses this to assign device names to pci io/mem ranges
 */

void	release_region(int iobase,int size) { }
int	request_region( int iobase, int size, char *name ) { return TRUE; }

void udelay(int ms) { usleep(ms*1000); };

int pci_present() { return TRUE; };

int BLK_DEFAULT_QUEUE(int MAJOR_NR) { dummy_printf("**** BLK_DEFAULT_QUEUE(int MAJOR_NR) ****\n"); };

void blk_init_queue(int BLK, void *DEVICE_REQUEST_FUNC ) {};

//    blk_init_queue(BLK_DEFAULT_QUEUE(MAJOR_NR), DEVICE_REQUEST);

void pci_unregister_driver() 
{
	printf("%s\n","pci_unregister_driver()\n");
};

void blk_cleanup_queue() { dummy_printf("****  blk_cleanup_queue() ****\n"); };

int put_user(int numblocks, long * arg) {};

int copy_to_user(void *arg, void *current_format,int size) {};

int pci_resource_start(struct pci_dev *pcidev, int address_index)
{
	if (address_index!=0) 
	{
		printf("NOT SUPPORTED: pci_resource_start() get address %i\n",address_index);
	}

	return pcidev -> io_base_address;
}

int  pci_module_init(struct pci_driver *cwfloppy_pci) 
{
	int i,ii;
	int mk = 0;
	int index=0;
	int err = 1;
	struct pci_dev pcidev;
	struct PCIResourceRange *pci_range;

	printf("Probe %s ?\n",cwfloppy_pci -> name);

	for (i = 0; cwfloppy_pci ->id_table[i].vendor != 0;i++ )
	{
		if (pcidev.device = (void *) I_PCI->FindDeviceTags(
			FDT_VendorID,		cwfloppy_pci ->id_table[i].vendor,	
			FDT_DeviceID,		cwfloppy_pci ->id_table[i].device,
			FDT_Index,		index,
			TAG_DONE))
		{

			if (pcidev.device -> ReadConfigWord ( PCI_SUBSYSTEM_VENDOR_ID ) == cwfloppy_pci ->id_table[i].subvendor)
			{
				for (ii = 0; ii < 6; ii++) 
				{
					if (pci_range = pcidev.device -> GetResourceRange(ii))
					{
						if (pci_range -> Flags & PCI_RANGE_IO)
						{
							printf("%i: pci_base_address %x\n",ii,pci_range -> BaseAddress); 
							my_cw_device = pcidev.device;

							pcidev.io_range = pci_range;
							pcidev.io_base_address = pci_range -> BaseAddress;
							printf("controllers %i\n",index+1);
							printf("probe controller:\n");

							cwfloppy_pci -> probe( &pcidev, &cwfloppy_pci ->id_table[i]);
							index++;
							err = 0;
						}
						else
						{
							// free any range i don't need
							pcidev.device -> FreeResourceRange(pci_range);
							my_cw_device = pcidev.device;
						}
					}
				}
			}
		}
	}

	return err; 
}


unsigned char inb(unsigned int port) 
{
	      return my_cw_device -> InByte(port); 
}


void outb(unsigned char value,unsigned int port) 
{
	      my_cw_device -> OutByte(port,value);
}

