//#include "cw_trackdisk.h"

#include <exec/devices.h>
#include <devices/trackdisk.h>
#include <devices/newstyle.h>
#include <dos/dosextens.h>

#include <proto/exec.h>
#include <proto/dos.h>
#include <proto/expansion.h>
#include <proto/timer.h>

#if defined(AROS)
#  include <aros/debug.h>
#endif

#if !defined(AROS)
struct my_Message
{
    struct Message real_msg;
    int type;
    char    *txt;
};
#endif

/* some basics msg is in stack so msg shoud be unique for every PutMsg */

void write_txt(struct MsgPort *port,char *txt)
{
    struct my_Message *msg;
    int ready = 0;
    int tlen;
    int n;

#if !defined(DEBUG_OUTPUT)
    return;
#endif
#if defined(AROS)
    bug( txt );
    //Delay(3);
    return;
#else
    IExec->DebugPrintF( txt );

    if (!port) return;
    if (!IDOS) return;
    if (!txt) return;

    IExec->Disable();

    if (msg = (my_Message *)AllocVec( sizeof(struct my_Message) , MEMF_SHARED |MEMF_CLEAR))
    {
        // Alloc txt as shared
        for (tlen=0;txt[tlen]!=0;tlen++);

        if (msg -> txt = (char *)AllocVec( tlen + 1 , MEMF_SHARED | MEMF_CLEAR))
        {
            // Copy txt
            for (n=0;n<tlen;n++) { msg -> txt[n] = txt[n]; }
            msg -> txt[ tlen ] = 0;
            msg -> real_msg.mn_Node.ln_Type = NT_MESSAGE;
            PutMsg(port, (struct Message *) msg);
        }
    }
       
    IExec->Enable();
#endif
}


void dos_write_txt(int fd,char *text)
{
    int n;
#if !defined(DEBUG_OUTPUT)
    return;
#endif
    if (fd)
    {
        for (n=0;text[n]!=0;n++);
#if defined(AROS)
        Write((void *)fd, text, n ); // FIXME
#else
        IDOS->Write(fd,text,n);
#endif
    }
} 

void write_num(struct MsgPort *port,char *txt,int num)
{
    int n,nn,sym=0;
    int tall;
    char buffer[100];

#if !defined(DEBUG_OUTPUT)
    return;
#endif

    for(n=0;n<100;n++) { buffer[n]=' '; }

    nn = 0;
    for(n=0;txt[n];n++) { buffer[n]=txt[n]; nn++; }
    nn+=2;

    tall = num;
    if (tall<0) num = -num;

    buffer[nn+8]='0';
    buffer[nn+9]=10;
    buffer[nn+10]=0;

    for (n=8;n>-1;n--)
    {
        if (num>0)
        {
            sym = nn+n-1;
            buffer[nn+n]=(num % 10) + '0';
            num /= 10;
        }
    }

    if (sym<0)  sym = 0;
    if (tall<0) buffer[sym]='-';
    write_txt(port,buffer);

} 

void write_num_no_enter(struct MsgPort *port,char *txt,int num)
{
    int n,nn,sym=0;
    int tall;
    char buffer[100];

#if !defined(DEBUG_OUTPUT)
    return;
#endif
    for(n=0;n<100;n++)
    {
        buffer[n]=' ';
    }

    nn = 0;
    for(n=0;txt[n];n++)
    {
        buffer[n]=txt[n];
        nn++;
    }
    nn+=2;

    tall = num;
    if (tall<0)
        num = -num;

    buffer[nn+8]='0';
    buffer[nn+9]=0;
    buffer[nn+10]=0;

    for (n=8;n>-1;n--)
    {
        if (num>0)
        {
            sym = nn+n-1;
            buffer[nn+n]=(num % 10) + '0';
            num /= 10;
        }
    }

    if (sym<0)
        sym = 0;
    if (tall<0) 
        buffer[sym]='-';
    write_txt(port,buffer);
} 


char alfa[]="0123456789ABCDEF";

void write_hex(struct MsgPort *port,char *txt,int num)
{
    int n,nn;
    char buffer[100];

#if !defined(DEBUG_OUTPUT)
    return;
#endif

    for(n=0;n<100;n++) { buffer[n]=' '; }

    nn = 0;
    for(n=0;txt[n];n++) { buffer[n]=txt[n]; nn++; }
    nn+=2;

    buffer[nn+8]='0';
    buffer[nn+9]=10;
    buffer[nn+10]=0;

    if (num<0)
    {
        num = -num;
    }

    for (n=8;n>-1;n--)
    {
        if (num>0)
        {
            buffer[nn+n]=alfa[(num % 16)] ;
            num /= 16;
        }
    }

    write_txt(port,buffer);
}

void write_hex_no_enter(struct MsgPort *port,char *txt,unsigned int num)
{
    int n,nn;
    char buffer[100];
#if !defined(DEBUG_OUTPUT)
    return;
#endif
    for(n=0;n<100;n++) { buffer[n]=' '; }

    nn = 0;
    for(n=0;txt[n];n++) { buffer[n]=txt[n]; nn++; }
    nn+=2;

    buffer[nn+8]='0';
    buffer[nn+9]=0;
    buffer[nn+10]=0;

    if (num<0)
    {
        num = -num;
    }

    for (n=8;n>-1;n--)
    {
        if (num>0)
        {
            buffer[nn+n]=alfa[(num % 16)] ;
            num /= 16;
        }
    }

    write_txt(port,buffer);
}
