#ifndef __DEV_CMD_H__
#define __DEV_CMD_H__

#include <devices/trackdisk.h>
#include <devices/newstyle.h>

#include "catweasel.h"
#include "ami_probe.h"

typedef struct
{
	int cmd;
	char	*txt;
	int (*func) (struct cwDevUnit *unit,struct IOExtTD *ioreq);
}	dev_cmd_type ;


void motor_on(struct cwDevUnit *unit);
void motor_off(struct cwDevUnit *unit);
int DEV_CMD_MOTOR(struct cwDevUnit *unit,struct IOExtTD *ioreq);
int DEV_CMD_SETFORMAT(struct cwDevUnit *unit,struct IOExtTD *ioreq);
int clear_track(struct cwDevUnit *unit, struct IOExtTD *ioreq);
void cw_reset_ram_pointer_w(struct cwDevUnit *unit);
void cw_reset_ram_pointer_r(struct cwDevUnit *unit);
int read_track (struct cwDevUnit *unit, struct IOExtTD *ioreq);
int check_encode(struct cwDevUnit *unit, struct IOExtTD *ioreq);
int write_track(struct cwDevUnit *unit, struct IOExtTD *ioreq);
int cmd_update(struct cwDevUnit *unit, struct IOExtTD *ioreq);
int format_track(struct cwDevUnit *unit, struct IOExtTD *ioreq);
int std_cyl(struct cwDevUnit *unit, struct IOExtTD *ioreq,int dev_size,int  (* track_func) (struct cwDevUnit *unit, struct IOExtTD *ioreq) );
int read_cyl(struct cwDevUnit *unit, struct IOExtTD *ioreq);
int rawread_cyl(struct cwDevUnit *unit, struct IOExtTD *ioreq);
int write_cyl(struct cwDevUnit *unit, struct IOExtTD *ioreq);
int rawwrite_cyl(struct cwDevUnit *unit, struct IOExtTD *ioreq);
int format_cyl(struct cwDevUnit *unit, struct IOExtTD *ioreq);
int clear_cyl(struct cwDevUnit *unit, struct IOExtTD *ioreq);
int DEV_CMD_TD_CHANGESTATE(struct cwDevUnit *unit, struct IOExtTD *ioreq);
int DEV_CMD_TD_PROTSTATUS(struct cwDevUnit *unit, struct IOExtTD *ioreq);
int DEV_CMD_NSCMD_DEVICEQUERY(struct cwDevUnit *unit,struct IOExtTD *ioreq);
int ext_code(struct cwDevUnit *unit, struct IOExtTD *ioreq);
int DEV_CMD_GETGEOMETRY(struct cwDevUnit *unit,struct IOExtTD *ioreq);
int DEV_CMD_ADDCHANGEINT(struct cwDevUnit *unit,struct IOExtTD *ioreq);
int DEV_CMD_GETDRIVETYPE(struct cwDevUnit *unit,struct IOExtTD *ioreq);
int DEV_CMD_GETNUMTRACKS(struct cwDevUnit *unit,struct IOExtTD *ioreq);
int DEV_CMD_VOID(struct cwDevUnit *unit,struct IOExtTD *ioreq);
int DEV_CMD_PROTSTATUS(struct cwDevUnit *unit,struct IOExtTD *ioreq);
int cmd_execute(struct cwDevUnit *unit,struct IORequest *ioreq);
int cmd_eject( struct cwDevUnit *unit, struct IOExtTD *ioreq );

extern UWORD SupportedCommands[];
extern dev_cmd_type dev_cmd_list[];

#endif  //__DEV_CMD_H_

