#include "cwfloppy.h"

const struct cwfloppy_format cw_formats[ 4 ] = {
    { "amigadd",
      512, 1760, 11, 2, 80, 0,
      1, 250, 240, &cw_codec_amiga },

    { "amigahd",
      512, 2*1760, 22, 2, 80, 0,
      0, 250, 240, &cw_codec_amiga },

    { "msdosdd",
      512, 1440, 9, 2, 80, 0,
      1, 250, -1, &cw_codec_msdos },

    { "msdoshd",
      512, 2*1440, 18, 2, 80, 0,
      0, 240, -1, &cw_codec_msdos },
};

void SwitchEndian( unsigned short *value )
{
#if defined(AROS)
#else
    unsigned short tNewValue;
    tNewValue  = (*value & 0xFF) << 8;
    tNewValue |= (*value >> 8) & 0xFF;
    *value = tNewValue;
#endif
};

__inline__ void CWSetCReg(struct catweasel_contr *c, unsigned char clear, unsigned char set)
{
    c->control_register = (c->control_register & ~clear) | set;

    PCICARD_OUTBYTE(c->pcicard, c->io_sr,c->control_register);
}

void cw_udelay(
#if defined(AROS)
struct timerequest *ior,
#else
struct TimeRequest *ior,
#endif
int usec)
{
#if defined(AROS)
        ior -> tr_node.io_Command = TR_ADDREQUEST;
        ior -> tr_time.tv_secs = 0 ;
        ior -> tr_time.tv_micro = usec;
#else
        ior -> Request.io_Command = TR_ADDREQUEST;
        ior -> Time.Seconds = 0 ;
        ior -> Time.Microseconds = usec;
#endif
#if defined(AROS)
#else
        IExec = ((struct ExecIFace *)((*(struct ExecBase **)4)->MainInterface));
        IExec -> 
#endif        
        DoIO((struct IORequest *) ior);
}

void cw_msdelay(
#if defined(AROS)
struct timerequest *ior,
#else
struct TimeRequest *ior,
#endif
        int msec)
{
#if defined(AROS)
        ior -> tr_node.io_Command = TR_ADDREQUEST;
        ior -> tr_time.tv_secs = 0 ;
        ior -> tr_time.tv_micro = msec * 1000;
#else
        ior -> Request.io_Command = TR_ADDREQUEST;
        ior -> Time.Seconds = 0 ;
        ior -> Time.Microseconds = msec * 1000;
#endif

#if defined(AROS)
#else
        IExec = ((struct ExecIFace *)((*(struct ExecBase **)4)->MainInterface));
        IExec ->
#endif        
         DoIO((struct IORequest *) ior);
/*
        IExec -> CloseDevice( (struct IORequest *) ioint);

    }
    if (ioint)      IExec -> DeleteIORequest( (struct IORequest *) ioint );
    if (cw_msg) IExec -> DeletePort(cw_msg);
*/
}


// define cw_msdelay(a,b) cw_udelay(a,b*1000)

/*
void cw_udelay(struct TimeRequest *ior,int usec)
{
    struct Message *msg;

#if defined(AROS)
    ior -> tr_node.io_Command = TR_ADDREQUEST;
    ior -> tr_time.tv_secs = 0 ;
    ior -> tr_time.tv_micro= usec;
#else
    IExec = ((struct ExecIFace *)((*(struct ExecBase **)4)->MainInterface));
    ior -> Request.io_Command = TR_ADDREQUEST;
    ior -> Time.Seconds = 0 ;
    ior -> Time.Microseconds = usec;
    IExec ->
#endif    
     DoIO((struct IORequest *) ior);
}

void cw_msdelay(struct TimeRequest *ior,int msec)
{
    struct Message *msg;

#if defined(AROS)
    ior -> tr_node.io_Command = TR_ADDREQUEST;
    ior -> tr_time.tv_secs = 0 ;
    ior -> tr_time.tv_micro = msec * 1000;
#else
    IExec = ((struct ExecIFace *)((*(struct ExecBase **)4)->MainInterface));

    ior -> Request.io_Command = TR_ADDREQUEST;
    ior -> Time.Seconds = 0 ;
    ior -> Time.Microseconds = msec * 1000;
    IExec ->
#endif    
     DoIO((struct IORequest *) ior);
}
*/

/*
void cw_msdelay(struct TimerIFace *itime,int time)
{
    struct EClockVal get;
    struct EClockVal end;
    unsigned int ts;
    unsigned int tms;
    int cnt = 0;

    ts = itime -> ReadEClock(&get);
    end.ev_hi = get.ev_hi;
    end.ev_lo = get.ev_lo + (ts  * time / 1000);
    if (end.ev_lo<get.ev_lo) end.ev_hi++;

    for(;;)
    {
        itime -> ReadEClock(&get);
        if ((get.ev_hi=end.ev_hi)&&(get.ev_lo>end.ev_lo)) break;
        if ((get.ev_hi>end.ev_hi)&&(get.ev_lo<end.ev_lo)) break;
    }
}
*/

/*
 * Catweasel -- Advanced Floppy Controller
 * Linux device controller
 * Low-level routines
 *
 * Copyright (C) 1998-2002 Michael Krause
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifdef linux
#include <asm/io.h>
#if defined(CONFIG_PCI) && LINUX_VERSION_CODE >= 0x020400
#include <linux/pci.h>
#endif
#endif

#include "catweasel.h"

static void CWTriggerStep(struct catweasel_contr *c)
{
    CWSetCReg(c, c->crm_step, 0);
    cw_msdelay(c -> ms_timer,5);
    CWSetCReg(c, 0, c->crm_step);
    cw_msdelay(c -> ms_timer,5);
}

void catweasel_init_unit(struct catweasel_contr *c)
{
    int i,j;
    struct PCIDevice    *pcicard = c->pcicard;
    // select all drives, step inside 
    CWSetCReg(c, c->crm_dir | c->crm_sel0 | c->crm_sel1, 0);

    for(i=0;i<3;i++) CWTriggerStep(c);

    for(i=0;i<2;i++)
    {
//      c->drives[i].number = i;
//      c->drives[i].contr = c;
    
    // select only the respective drive, step to track 0 

        if(i == 0) 
        {
            CWSetCReg(c, c->crm_sel0, c->crm_dir | c->crm_sel1);
        }
        else
        {
            CWSetCReg(c, c->crm_sel1, c->crm_dir | c->crm_sel0);
        }
    
        for(j = 0; j < 86 && (PCICARD_INBYTE( pcicard, c->io_sr) & c->srm_trk0); j++)
            CWTriggerStep(c);
    }

    int tUnit;
    for ( tUnit = 0 ; tUnit < 2 * NUMBER_OF_SUPPORTED_FORMATS ; tUnit++ )
    {
        if ( c->cw_unit[ tUnit ] )
        {
            if(j < 86)
            {
                c->cw_unit[ tUnit ]->type = 1;
                c->cw_unit[ tUnit ]->track = 0;
            } else {
                c->cw_unit[ tUnit ]->type = 0;
            }
        }
    }
    
    CWSetCReg(c, 0, c->crm_sel0 | c->crm_sel1); // deselect all drives
}

void catweasel_init_controller(struct catweasel_contr *c)
{
    int i, j;
    struct PCIDevice    *pcicard = c->pcicard;
//  struct TimeRequest  *IO_Timer = c->driver->ioreq_timer;

    if(!c->io_base) return;

    switch(c->type)
    {
        case CATWEASEL_TYPE_MK1:
            c->crm_sel0 = 1 << 5;
            c->crm_sel1 = 1 << 4;
            c->crm_mot0 = 1 << 3;
            c->crm_mot1 = 1 << 7;
            c->crm_dir  = 1 << 1;
            c->crm_step = 1 << 0;
            c->srm_trk0 = 1 << 4;
            c->srm_dchg = 1 << 5;
            c->srm_writ = 1 << 1;
            c->io_sr    = c->io_base + 2;
            c->io_mem   = c->io_base;
            break;
        case CATWEASEL_TYPE_MK3:
        case CATWEASEL_TYPE_MK4:
            write_txt( c->driver->debug_port, "Initing MK4..." );
            c->crm_sel0 = 1 << 2;
            c->crm_sel1 = 1 << 3;
            c->crm_mot0 = 1 << 1;
            c->crm_mot1 = 1 << 5;
            c->crm_dir  = 1 << 4;
            c->crm_step = 1 << 7;
            c->srm_trk0 = 1 << 2;
            c->srm_dchg = 1 << 5;
            c->srm_writ = 1 << 6;
            c->io_sr    = c->io_base + 0xe8;
            c->io_mem   = c->io_base + 0xe0;
            break;
        default:
            return; 
    }

    c->control_register = 255;
}

void catweasel_free_controller(struct catweasel_contr *c)
{
    if(!c->io_base) return;

    // all motors off, deselect all drives 
    CWSetCReg(c, 0, c->crm_mot0 | c->crm_mot1 | c->crm_sel0 | c->crm_sel1);
}

void catweasel_select(struct catweasel_contr *c, int dr0, int dr1)
{
    CWSetCReg(c, dr0*c->crm_sel0 | dr1*c->crm_sel1, (!dr0)*c->crm_sel0 | (!dr1)*c->crm_sel1);
}

void catweasel_set_motor(struct cwDevUnit *d, int on)
{
    write_num( d->driver->debug_port, (char *)"catweasel_set_motor", on );
    if(d->cw_unit_num      == 0) 
    {
        CWSetCReg(d->controller, on*d->controller->crm_mot0, (!on)*d->controller->crm_mot0);
    }
    else
    {
        CWSetCReg(d->controller, on*d->controller->crm_mot1, (!on)*d->controller->crm_mot1);
    }
}

int catweasel_seek(struct cwDevUnit *d, int t)
{
    int x;

    write_num( NULL, "Seek to ", t );

    if(t == 0)
    {
        // Recalibrate using explicit Track 0 sensing 
        struct catweasel_contr *c = d->controller;

        CWSetCReg(c, c->crm_dir, 0);

        for(x = 0; x < 3; x++)  CWTriggerStep(c);

        CWSetCReg(c, 0, c->crm_dir);

        for(x = 0; x < 86 && (PCICARD_INBYTE( c->pcicard, c->io_sr) & c->srm_trk0); x++)
        CWTriggerStep(c);

        if(x == 86)
        {
            return 0;
        }

        d->track = 0;
        return 1;
    }

    if(t >= 80)
    {
        return 0;
    }

    x = t - d->track;
    if(!x) return 1;

    if(x >= 0)
    {
        CWSetCReg(d->controller, d->controller->crm_dir, 0);
    } else {
        CWSetCReg(d->controller, 0, d->controller->crm_dir);
        x = -x;
    }

    while(x--)  CWTriggerStep(d->controller);

    d->track = t;
    return 1;
}

int catweasel_disk_changed(struct cwDevUnit *d)
{
    int ot, t, changed = 0;
    struct PCIDevice *pcicard =  d->controller->pcicard;

    if(PCICARD_INBYTE( pcicard, d->controller->io_sr) & d->controller->srm_dchg)
    {
        if(!d->diskindrive) 
        {
            // first usage of this drive, issue disk change 
            d->diskindrive = 1;
            changed = 1;
        } else {
            // there's still a disk in there, no change detected. 
        }
    } 
    else 
    {
        ot = d->track;
        if(ot == 79)
            t = 78;
        else
            t = ot + 1;
    
        catweasel_seek(d, t);
        catweasel_seek(d, ot);
    
        if(!(PCICARD_INBYTE( pcicard, d->controller->io_sr) & d->controller->srm_dchg)) 
        {
            if(!d->diskindrive) 
            {
                // drive still empty, nothing has happened 
            }
            else
            {
                // disk has been removed 
                d->diskindrive = 0;
                changed = 1;
            }
        } 
        else 
        {
            // disk has been inserted 
            d->diskindrive = 1;
            changed = 1;
        }
    }

    return changed;
}

int catweasel_write_protected(struct cwDevUnit *d)
{
    if ( !(PCICARD_INBYTE( d->controller->pcicard, d->controller->io_sr) & 8) )
        write_txt( d->driver->debug_port, (char *)"Write protected!" );
    return !(PCICARD_INBYTE( d->controller->pcicard, d->controller->io_sr) & 8);
}

int catweasel_read(struct cwDevUnit *d)
{
    int             io_base ;
    struct PCIDevice    *pcicard ;
#if defined(AROS)
    struct timerequest *IO_Timer;
#else
    struct TimeRequest  *IO_Timer;
#endif
    struct MsgPort  *port;
    int             time;

    io_base = d->controller->io_base;
    pcicard = d->controller->pcicard;
    IO_Timer    = d->controller->ms_timer;
    port        = d->driver->debug_port;
    time = cw_formats[d->format].readtime ;

//  write_num(port,"write for one rotation ms",time);
//  write_txt(port, cw_formats[d->format].clock == 0 ? "clock 28 hz\n" : "clock 14 hz\n");

    if(!(PCICARD_INBYTE( pcicard, d->controller->io_sr) & d->controller->srm_dchg))
    {
        write_txt(port,(char *)"ERROR: srm_dchg or disk indrive issue\n");

        return 0;
    }

    CWSetCReg(d->controller, 1<<6, (!d->side)<<6); // set disk side 

    PCICARD_OUTBYTE( pcicard, io_base + 0xe4,0); // Reset memory pointer 
    switch(cw_formats[d->format].clock)
    {
        case 0: // 28MHz 
            PCICARD_OUTBYTE( pcicard, io_base + 0xec,128);
            break;
        case 1: // 14MHz 
            PCICARD_OUTBYTE( pcicard, io_base + 0xec,0);
            break;
    }

    write_txt( port, (char *)"catweasel_read!" );

    PCICARD_INBYTE( pcicard, io_base + 0xe0);
    PCICARD_INBYTE( pcicard, io_base + 0xe0);
    PCICARD_OUTBYTE( pcicard, io_base + 0xec,0); // no IRQs, no MFM predecode 
    PCICARD_INBYTE( pcicard, io_base + 0xe0);
    PCICARD_OUTBYTE( pcicard, io_base + 0xec,0); // don't store index pulse 
    PCICARD_OUTBYTE( pcicard, io_base + 0xe4,0); // Reset memory pointer 

    PCICARD_INBYTE( pcicard, io_base + 0xf0);        // start reading 
    cw_msdelay(IO_Timer,time+2);        // wait for one rotation
    PCICARD_INBYTE( pcicard, io_base + 0xe4);        // stop reading, don't reset RAM pointer 

    PCICARD_OUTBYTE( pcicard, io_base + 0xe0,128);   // add data end mark 
    PCICARD_OUTBYTE( pcicard, io_base + 0xe4,0);     // Reset memory pointer 

    write_txt( port, (char *)"done!");

//    write_hex( port, "controller read ",  d->controller -> PCICARD_INBYTE( pcicard, d->controller->io_mem) );

    return 1;
}

int catweasel_read_raw_data( struct cwDevUnit *d, BYTE *data, int maximumLength )
{
    const int           iobase = d->controller->io_mem;
    struct PCIDevice    *pcicard = d -> controller -> pcicard;
    BYTE                *tDataPointer = data;
    int                 tCounter = 0;

    // Read as much data as the catweasel is prepared to give us....
    char tByte = 0;

    if ( maximumLength <= 0 )
        return 0;

    do
    {
        tByte = PCICARD_INBYTE( pcicard, iobase);
        *tDataPointer = tByte;
        tDataPointer++;
        tCounter++;

//        write_hex( d->driver->debug_port, "", *(tDataPointer-1) );

    } while ( (tByte & 0x80) == 0 && tCounter < maximumLength );

    if ( tCounter == maximumLength )
        write_txt( d->driver->debug_port, (char *)"Maximum length reached." );
    else
        write_txt( d->driver->debug_port, (char *)"Reached end of Catweasel buffer." );

    return tCounter;
}

int catweasel_write_raw_data( struct cwDevUnit *d, BYTE *data, int maximumLength )
{
    const int           iobase = d->controller->io_mem;
    struct PCIDevice    *pcicard = d -> controller -> pcicard;
    BYTE                *tDataPointer = data;
    int                 tCounter = 0;

    // Read as much data as the catweasel is prepared to give us....
    char tByte = 0;

    if ( maximumLength <= 0 )
        return 0;

    do
    {
//        write_hex( d->driver->debug_port, "", *tDataPointer );
        PCICARD_OUTBYTE( pcicard, iobase, *tDataPointer );
        tDataPointer++;
        tCounter++;

//        write_hex( d->driver->debug_port, "", *(tDataPointer-1) );

    } while ( tCounter < maximumLength );

    return tCounter;
}


static void
catweasel_wait_for_writing_flag (struct cwDevUnit *d,
                 int status, // Wait for this specified 'status' 
                 int timeout_ms)
{
    struct PCIDevice    *pcicard =  d->controller->pcicard;

    while(((PCICARD_INBYTE( pcicard, d->controller->io_sr) & d->controller->srm_writ) ? 1 : 0) != status && timeout_ms > 0)
    {
        cw_msdelay(d->controller->ms_timer,20);
        timeout_ms -= 20;
    }

    if (timeout_ms==0) write_txt(d->driver->debug_port,(char *)"exit on time out\n");
}

int catweasel_write (struct cwDevUnit *d)
{
    int             io_base = d->controller->io_base;
    struct PCIDevice    *pcicard =  d->controller->pcicard;
#if defined(AROS)
    struct timerequest *IO_Timer
#else
    struct TimeRequest  *IO_Timer
#endif
     = d->controller->ms_timer;
    int             time = cw_formats[d->format].writetime;


    if(!(PCICARD_INBYTE( pcicard, d->controller->io_sr) & d->controller->srm_dchg))
        return 0;

    CWSetCReg(d->controller, 1<<6, (!d->side)<<6); // set disk side

    PCICARD_OUTBYTE( pcicard, io_base + 0xe4,0); // Reset memory pointer

    switch(cw_formats[d->format].clock)
    {
        case 0: // 28MHz
            PCICARD_OUTBYTE( pcicard, io_base + 0xec,128);
            break;
        case 1: // 14MHz
            PCICARD_OUTBYTE( pcicard, io_base + 0xec,0);
            break;
    }

    PCICARD_INBYTE( pcicard, io_base + 0xe0);
    PCICARD_OUTBYTE( pcicard, io_base + 0xec,128); // write enable
    PCICARD_INBYTE( pcicard, io_base + 0xe0);
    PCICARD_INBYTE( pcicard, io_base + 0xe0);
    PCICARD_INBYTE( pcicard, io_base + 0xe0);
    PCICARD_INBYTE( pcicard, io_base + 0xe0);
    PCICARD_INBYTE( pcicard, io_base + 0xe0);
    PCICARD_INBYTE( pcicard, io_base + 0xe0);

    if(time > 0)
    {
        PCICARD_OUTBYTE( pcicard, io_base + 0xf4,0); // unconditional write START
        cw_msdelay(IO_Timer,time);
    }
    else
    {
        PCICARD_OUTBYTE( pcicard, io_base + 0xf0,0); // ?????? indexed write START
        catweasel_wait_for_writing_flag(d, 0, 300);
        cw_msdelay(IO_Timer,190);
        catweasel_wait_for_writing_flag(d, 1, 50);
    }

    PCICARD_INBYTE( pcicard, io_base + 0xe4); // Abort writing
    PCICARD_INBYTE( pcicard, io_base + 0xe4); // Reset memory pointer

    return 1;
}
