/* A header for compatibility between Amiga-like OSes */

#ifndef __AROS_PCI_H__
#define __AROS_PCI_H__

#if defined(AROS)

#include <exec/exec.h>
#include <oop/oop.h>

struct PCIResourceRange
{
    void *BaseAddress;
    unsigned long Flags;
};

struct PCIDevice
{
    OOP_Object *mObject;
    ULONG mVendor, mProductID, mDMABase, mDMASize;
    ULONG mSubClass, mInterface;
};


void PCIDevice_OutByte( struct PCIDevice *device, int address, unsigned char data );
unsigned char PCIDevice_InByte( struct PCIDevice *device, int address );
void PCIDevice_Obtain(struct PCIDevice *device);
struct PCIResourceRange *GetResourceRange(struct PCIDevice *device, int range );
void FreeResourceRange( struct PCIDevice *device, struct PCIResourceRange *range);
unsigned short ReadConfigWord( struct PCIDevice *device );

void FindDeviceTags();

#endif


#endif

