#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <clib/exec_protos.h>
#include <proto/exec.h>
#include <proto/dos.h>
#include <exec/exec.h>
#include <exec/types.h>
#include <exec/memory.h>
#include <exec/devices.h>
#include <dos/dos.h>
#include <dos/dosextens.h>
#include <clib/alib_protos.h>
#include <devices/trackdisk.h>

#include <aros/debug.h>

struct ExecBase *SysBase;

int ParseArgs( int argc, char *argv[], int *flags, int *unit, char *filename, int *startTrack, int *endTrack)
{
    int tParam;

    *flags= 0; // Amiga DD
    *unit = 0;
    *startTrack = 0;
    *endTrack = -1;
    BOOL tFilenameIsGiven = FALSE;

    for ( tParam = 1; tParam < argc ; tParam++ )
    {
        if ( !stricmp( argv[ tParam ], "-flags" ) )
        {
            *flags = atoi( argv[ tParam+1 ] );
            tParam++;
        }
        else if ( !stricmp( argv[ tParam ], "-unit" ) )
        {
            *unit = atoi( argv[ tParam+1 ] );
            tParam++;
        }
        else if ( !stricmp( argv[ tParam ], "-endtrack" ) )
        {
            *endTrack = atoi( argv[tParam+1 ] );
            tParam++;
        }
        else if ( !stricmp( argv[ tParam ], "-starttrack" ) )
        {
            *startTrack = atoi( argv[tParam+1 ] );
            tParam++;
        }
        else
        {
            strcpy( filename, argv[ tParam ] );
            tFilenameIsGiven = TRUE;        
        }
    }

    return tFilenameIsGiven;
}

BOOL ReadDisk( struct IOExtTD *ioReq, BYTE **buffer, int flags, int *size, int startTrack, int endTrack )
{
    struct DriveGeometry tGeometry;
    int tSize = -1;
    int tTrack;
    int tTrackSize;
    int tNumberOfTracks;
    
    ioReq->iotd_Req.io_Length = sizeof( struct DriveGeometry );
    ioReq->iotd_Req.io_Data = &tGeometry;
    ioReq->iotd_Req.io_Flags = flags;
    ioReq->iotd_Req.io_Command = TD_GETGEOMETRY;
    DoIO( (struct IORequest *)ioReq );
    
    tSize = tGeometry.dg_SectorSize * tGeometry.dg_TotalSectors;
    printf ("Disk size is %d bytes.\n", tSize );

    *buffer = (BYTE *)AllocVec( tSize, MEMF_PUBLIC | MEMF_CLEAR );
    bug( "buffer is at %p.\n", *buffer );

    tNumberOfTracks = tGeometry.dg_Cylinders * tGeometry.dg_Heads;

    if ( endTrack == -1 )
        endTrack = tNumberOfTracks-1;

    tTrackSize = tGeometry.dg_TrackSectors * tGeometry.dg_SectorSize;
    ioReq->iotd_Req.io_Length = tTrackSize;
    ioReq->iotd_Req.io_Data = *buffer + startTrack * tTrackSize;
    ioReq->iotd_Req.io_Offset = startTrack * tTrackSize;
    ioReq->iotd_Req.io_Command = CMD_READ;

    printf( "Reading...\n" );

    for ( tTrack = startTrack ; tTrack <= endTrack ; tTrack++ )
    {
        //printf( "Reading track %d\n", tTrack );
        DoIO( (struct IORequest *)ioReq);

        if ( ioReq->iotd_Req.io_Error == 29 )
        {
            printf( "No disk in drive!\n" );
            tTrack = tNumberOfTracks;
            ioReq->iotd_Req.io_Offset = tSize;
            return FALSE;
        }

        if ( ioReq->iotd_Req.io_Error)
            printf( "Error %d reading track %d.\n", ioReq->iotd_Req.io_Error,tTrack );
    
        ioReq->iotd_Req.io_Data += tTrackSize;
        ioReq->iotd_Req.io_Offset += tTrackSize;
    } 
    
    *size = tSize;
    
    return TRUE;
}

int main(int argc, char *argv[])
{
    SysBase = (struct ExecBase *)(*(struct ExecBase **)4);
    int tFlags, tUnit;
    char tFilename[ 1024 ];
    struct Library *DosBase;
 
    struct MsgPort *tDiskPort;
    struct IOExtTD *tDiskReq;
    BPTR tOutputFile;
    BYTE *tDiskBuffer;
    int tSize = -1;
    int tStartTrack, tEndTrack;
    BOOL tSuccess;
 
    if ( (DosBase = (struct Library *)OpenLibrary( "dos.library", 0L )) == NULL )
    {
        printf( "Couldn't open dos.library??\n" );
        exit(-10);    
    } 
 
    if ( ParseArgs( argc, argv, &tFlags, &tUnit, tFilename, &tStartTrack, &tEndTrack ) )
    {
        printf( "Using unit %d with flags %d to file %s.\n", tUnit, tFlags, tFilename );
        if ( (tDiskPort = CreatePort(NULL, 0 )) != NULL )
        {
            if ( tDiskReq= (struct IOExtTD *)CreateExtIO( tDiskPort, sizeof(struct IOExtTD)))
            {
                if ( !OpenDevice( "catweasel.device", tUnit, (struct IORequest *)tDiskReq, tFlags))
                {
                    tOutputFile = Open( tFilename,MODE_NEWFILE );

                    if (tOutputFile != NULL )
                    {
                        tSuccess = ReadDisk( tDiskReq, &tDiskBuffer, tFlags, &tSize, tStartTrack, tEndTrack );
                        if ( tSuccess )
                            Write( tOutputFile, tDiskBuffer, tSize );
                        Close( tOutputFile) ;                           

                        if ( tSuccess == FALSE )
                            
                            DeleteFile(tFilename );
                    }
                    else
                    {
                        printf( "Error opening file!\n" ); 
                    }
                }
            }   
            CloseDevice( (struct IORequest *) tDiskReq );
            DeleteExtIO( (struct IORequest *)tDiskReq );
        }
        DeletePort( tDiskPort );
    }
    else
    {
        printf( "CWDiskImage\n\nUsage:\nCWDiskImage [-flags <flags>] [-unit <unit number>] [-starttrack <track>] [-endtrack <track>] filename\n" );
        exit (-1);
    }
    
    CloseLibrary( DosBase );
    
    bug( "Freeing %p\n",tDiskBuffer );
    FreeVec( tDiskBuffer );
}

