#include <devices/timer.h>

#include <stdio.h>
#include <string.h>

#define DEBUG_NAME "debug window"

#include <exec/devices.h>
#include <devices/trackdisk.h>
#include <devices/newstyle.h>
#include <dos/dosextens.h> 

#include <proto/exec.h>
#include <proto/dos.h>
#include <proto/expansion.h>
#include <proto/timer.h>

#include <clib/exec_protos.h>
#include <exec/exec.h>

#if defined(AROS)
#  include <aros/symbolsets.h> 
#endif

#include "catweasel.h"
#include "cwfloppy.h"
#include "dev_cmd.h"

void check_for_disk_change(struct cw_driver *driver,struct cwDevUnit *unit)
{
    int i;
    int diskindrive;

    //write_hex( driver->debug_port, "Checking for disk change. Unit is", (int)unit );

    catweasel_select(unit -> controller, unit -> cw_unit_num == 0, unit -> cw_unit_num == 1);

    diskindrive = unit -> diskindrive;

    //write_txt( driver->debug_port, "Calling disk_changed" );

    // If we've not checked this drive yet...
    if ( unit->controller->mDiskChanged[ unit->cw_unit_num%2 ] == -1 || unit->controller->mDiskChanged[ unit->cw_unit_num%2 ] == 1 )
        catweasel_disk_changed(unit);

    if ( unit->controller->mDiskChanged[ unit->cw_unit_num%2 ] == -1 )
        unit->controller->mDiskChanged[ unit->cw_unit_num%2 ] = 0;     // The disk has not been changed, apparently.

    //write_txt( driver->debug_port, "Done checking." );

    if ( unit -> diskindrive != diskindrive )
    {
        write_txt( driver->debug_port, "Disk has been changed!" );
        // We have a disk change!
        unit->controller->mDiskChanged[ unit->cw_unit_num%2 ] = 1;

        unit -> ticks = 0;

        if (unit -> diskindrive == 1)
        {   unit -> timeout = 2;    }
        else
        {
            unit -> timeout = 0;
            unit -> ticks = 0;
            motor_off(unit);
        }

        for(i=0;i<80*2;i++)
        {
            if (unit -> buffered[i])
            {
                write_num( driver -> debug_port, (char *)"Free track", i );
#if defined(AROS)
                FreeVec(unit -> buffered[i]);
#else
                IExec->FreeVec(unit -> buffered[i]);
#endif
                unit -> buffered[i] = 0;
            }

            if (unit -> update[i])
                 unit -> update[i]=0;
        }

        if (unit -> interrupt)
        {
#if defined(AROS)
            Cause(unit->interrupt);
#else        
            IExec -> Cause( unit -> interrupt );
#endif
            write_txt( driver -> debug_port, (char *)"Report disk change...\n");
        }
        else
        {
            write_txt( driver -> debug_port, (char *)"No soft Interrupt\n" ) ;
        }
    }
    catweasel_select(unit->controller, 0, 0);
}
            
#if defined(AROS)
extern struct catweasel_contr *sharedController;
//extern struct Library *DosBase;
void task_begin()
#else            
void task_begin(  struct catweasel_contr  *contr )
#endif
{
#if defined(AROS)
    struct catweasel_contr *contr = sharedController;
#endif
    struct timerequest  *checktime;
    struct MsgPort  *checktime_msgport;
    struct MsgPort  *ms_timer_msgport;
    struct IOExtTD  *diskreq;
    struct cw_driver    *driver = contr->driver;
    struct cwDevUnit    *unit;
    int             cnt;
    int             i;
    int tErrorCode = 0;
    SysBase = EXECBASE;

#if defined(AROS)
    struct Library * DosBase;
    if ( (DosBase = (struct Library *)OpenLibrary( "dos.library", 0L )) == NULL )
        return;
#endif

    write_hex( driver->debug_port, "SysBase is ", (int)SysBase );

    unit = NULL;

#if defined(AROS)
    checktime_msgport = EXEC_CALL CreateMsgPort();
#else
    checktime_msgport = EXEC_CALL CreatePort(NULL,0);
#endif
     
#if defined(AROS)
    checktime = (struct timerequest *)CreateIORequest( checktime_msgport, sizeof(struct timerequest) ); 
#else        
    checktime = (struct TimeRequest *)IExec -> CreateIORequest( checktime_msgport, sizeof(struct TimeRequest) ); 
#endif    


    tErrorCode = EXEC_CALL OpenDevice("timer.device",0,(struct IORequest *) checktime,0L);
    
    if (tErrorCode != 0 )
    {
        write_txt( driver->debug_port, "Error opening timer.device.\n" );
        return;
    }
    
#if defined(AROS)
    checktime -> tr_node.io_Command = TR_ADDREQUEST;
    checktime -> tr_node.io_Flags = IOF_QUICK;
    checktime -> tr_time.tv_secs = 2 ;
    checktime -> tr_time.tv_micro = 0;
#else    
    checktime -> Request.io_Command = TR_ADDREQUEST;
    checktime -> Request.io_Flags = IOF_QUICK;
    checktime -> Time.Seconds = 2 ;
    checktime -> Time.Microseconds = 0;
#endif
    struct timerequest *ioint;

    // Open device for ms delays, one for every controller
#if defined(AROS)
    ms_timer_msgport = EXEC_CALL CreateMsgPort();
#else
    ms_timer_msgport = EXEC_CALL CreatePort(NULL,0);
#endif
#if defined(AROS)
    contr->ms_timer = (struct timerequest *)CreateIORequest( ms_timer_msgport, sizeof(struct timerequest) );
#else
    contr->ms_timer = (struct TimeRequest *) IExec -> CreateIORequest( ms_timer_msgport, sizeof(struct TimeRequest) );
#endif

    tErrorCode = EXEC_CALL OpenDevice("timer.device", 0, (struct IORequest *) contr -> ms_timer,0L);
    if (tErrorCode != 0 )
    {
        write_txt( driver->debug_port, "Error opening timer.device.\n" );
        return;
    }
    
    // Timer is ready we can now init drives
    catweasel_init_unit(contr);

    contr -> MsgPort->mp_SigTask = EXEC_CALL FindTask(NULL);
    contr -> MsgPort->mp_SigBit = EXEC_CALL AllocSignal(-1);

    contr->mShutDownNow = 0;

    EXEC_CALL SendIO( (struct IORequest *) checktime );   // send new request

    write_hex( driver->debug_port, "contr->MsgPort is ", (int)&contr->MsgPort );

    while ( contr->mShutDownNow == 0 )
    {
        BOOL tInRequest = FALSE;
        BOOL tStartNewRequest = FALSE;
    
        while (diskreq = (struct IOExtTD *) EXEC_CALL GetMsg(contr -> MsgPort))
        {
            write_txt( driver->debug_port, "Found message.\n" );
            tInRequest = TRUE;
            //write_hex( driver->debug_port, "diskreq", (int)diskreq );
            unit  = (struct cwDevUnit *) diskreq -> iotd_Req.io_Unit;
            //write_hex( driver->debug_port, "unit", (int)unit );
        
            if (driver == unit -> driver)
            {
                unit -> timeout = 2;
                diskreq -> iotd_Req.io_Error = cmd_execute( unit , (struct IORequest *) diskreq );

                if ( diskreq -> iotd_Req.io_Error == IOERR_NOCMD )
                {
                    write_num ( driver -> debug_port,   (char *)"Unknown command ",diskreq->iotd_Req.io_Command);
                    write_num ( driver -> debug_port,   (char *)"Length ",diskreq->iotd_Req.io_Length);
                    write_num ( driver -> debug_port,   (char *)"Offset ",diskreq->iotd_Req.io_Offset);
                }
            }
            else
            {
                write_txt   ( driver -> debug_port, (char *)"\nIOREQ: NOT CONFIG RIGHT!!\n");
                write_txt   ( driver -> debug_port, (char *)"TRY OPENING DEVICE FIRST IDIOT\n");
                write_hex( driver -> debug_port, (char *)"unit adr:", (int) unit );
            }

            if (diskreq->iotd_Req.io_Command != TD_ADDCHANGEINT)
            {
                // diskreq -> iotd_Req.io_Message.mn_Node.ln_Type = NT_REPLYMSG;
//                write_num( driver->debug_port, (char *)"Done command. Error is", diskreq->iotd_Req.io_Error );
//                diskreq->iotd_Req.io_Error = 2;
                 
                
                EXEC_CALL ReplyMsg( (struct Message *)  diskreq );
            }
        }
        
//        write_txt( driver->debug_port, "Done checking for commands.\n" );
        
        if ( tInRequest )
        {
//            write_hex( driver->debug_port, "AbortIO at ", (int)checktime );
            if ( EXEC_CALL AbortIO( (struct IORequest *) checktime ) == 0 )
            {
                EXEC_CALL WaitIO( (struct IORequest *) checktime );            
                tStartNewRequest = TRUE;
            }
        }
        else
        {
//            write_txt( driver->debug_port, "Checking timer....\n" );
            //write_hex( driver->debug_port, "checking IO from driver ", (int)driver );
            if ( EXEC_CALL CheckIO( (struct IORequest *) checktime ) )
            {
//                write_txt( driver->debug_port, "Timer finished\n");
                // Start of disk change checking.
                // Flag each disk having not been checked for changes.
                contr->mDiskChanged[ 0 ] = -1;
                contr->mDiskChanged[ 1 ] = -1;
    
                for ( i=0 ; i<2*NUMBER_OF_SUPPORTED_FORMATS ; i++ )
                {
                    // drive enabled , and it's time for a check
    
//                  write_hex( driver->debug_port, "Checking unit", (int)contr->cw_unit[ i ] );
                    if ( contr->cw_unit[ i ] )
                    {
                        if ( unit )
                        {
                            if (unit->timeout == 0)
                            {
//                                write_num( driver->debug_port, (char *)"Check_for_disk_change on unit", i );
                                check_for_disk_change(driver,contr -> cw_unit[i]);
    
                                if (unit -> ticks<100)  
                                    unit -> ticks ++;
                                unit -> timeout = unit -> ticks / 25 ;          // set delay
                            }
                            else
                            {
                                unit -> timeout --;
                            }
                        }
                    }
    
                    if ( contr->cw_unit[ i ] && contr->cw_unit[ i ]->needsUpdate > 0 )
                    {
                        // We should write to the disk now. Yay write-behind caching.
                        cmd_update( contr->cw_unit[ i ], NULL );
                        contr->cw_unit[ i ]->needsUpdate = 0;
                    }
    
                    if (   contr->cw_unit[ i ] && contr->cw_unit[ i ]->motor == 0
                        && contr->cw_unit[ i ]->motorChanged == 1 )
                    {
                        catweasel_select(unit -> controller, unit -> cw_unit_num == 0, unit -> cw_unit_num == 1);
                        catweasel_set_motor(unit , unit -> motor);
//                        write_txt( driver->debug_port, (char *)"motor off so delaying..." );
                        cw_msdelay(unit -> controller -> ms_timer, 500);
//                        write_txt( driver->debug_port, (char *)"done." );
                        contr->cw_unit[ i ]->motorChanged = 0;
                    }
                }
                //write_txt( driver->debug_port, "Done all formats." );
//                write_txt( driver->debug_port, "Waiting...\n") ;
                EXEC_CALL  WaitIO( (struct IORequest *) checktime );   // remove from queue safely
//                write_txt( driver->debug_port, "Waited.\n" );
    
                tStartNewRequest = TRUE;
    
//write_txt( driver->debug_port, "Gronk..." );
//Delay(1000);
            }
        }
//        write_txt( driver->debug_port, "Checking if new request necessary..\n" );
        if ( tStartNewRequest )
        {
#if defined(AROS)
            checktime -> tr_node.io_Command = TR_ADDREQUEST;
            checktime -> tr_node.io_Flags       = IOF_QUICK;
            checktime -> tr_time.tv_secs        = 2;
            checktime -> tr_time.tv_micro       = 0;

#else
            checktime -> Request.io_Command = TR_ADDREQUEST;
            checktime -> Request.io_Flags       = IOF_QUICK;
            checktime -> Time.Seconds            = 2;
            checktime -> Time.Microseconds       = 0;
#endif
//            write_hex( driver->debug_port, "SendIO at ", (int)checktime );
            EXEC_CALL SendIO( (struct IORequest *) checktime );   // send new request
        
        }
//        write_txt( driver->debug_port, "Now delaying...\n" );

        if ( tInRequest )
        {
#if defined(AROS)
#else
            driver->I_DOS->
#endif
            Delay( 1 );
        }
        else
        {
#if defined(AROS)
#else
            driver -> I_DOS -> 
#endif        
            Delay(10);
        }
    }

//    write_txt( driver->debug_port, (char *)"Shut down flag set!" );
    contr->mShutDownNow = 0;
return;
#if defined(AROS)
#else
    driver -> I_Exec -> 
#endif    
    CloseDevice( (struct IORequest *) checktime );
#if defined(AROS)
#else
    driver -> I_Exec -> 
#endif    
    CloseDevice( (struct IORequest *) contr -> ms_timer );

    if (checktime)          
#if defined(AROS)
#else
        driver -> I_Exec -> 
#endif        
        DeleteIORequest( (struct IORequest *) checktime );
    if (checktime_msgport)  
#if defined(AROS)
#else
        driver -> I_Exec -> 
#endif        
        DeletePort(checktime_msgport);

    if (contr -> ms_timer)  
#if defined(AROS)
#else
        driver -> I_Exec -> 
#endif        
        DeleteIORequest( (struct IORequest *) contr -> ms_timer );
    if (ms_timer_msgport)  
#if defined(AROS)
#else        
        driver -> I_Exec -> 
#endif        
        DeletePort(ms_timer_msgport);
}
