#include <stdio.h>
#include <string.h>

#define DEBUG_NAME "debug window"

#include <exec/devices.h>
#include <devices/trackdisk.h>
#include <devices/newstyle.h>
#include <dos/dosextens.h> 

#include <proto/exec.h>
#include <proto/dos.h>
#include <proto/expansion.h>
#include <proto/timer.h>

#include <clib/exec_protos.h>

#if defined(AROS)
#  include <aros/symbolsets.h> 
#  include <oop/oop.h>
#  include <hidd/pci.h>
#endif

#include "getdevicebase.i"

#define CW_FLAGS        LIBF_SUMUSED|LIBF_CHANGED
#define VERSION         1
#define REVISION        2
#define DEVICE_NAME     "catweasel.device"
#define VERSION_STR     "catweasel.device 1.2 (07.04.2010)"

/*
#include "amiga.c"
#include "dummy_amiga.i"
*/

/* extern APTR VecTable68K[]; */

#include "catweasel.h"

typedef struct
{
    int vendor;
    int device;
    int     subvendor;
    int     subdevice;
    int (*probe)    (struct cw_driver *driver, int controller);
}  pci_device_id ;

#include "dev_print.h"
//#include "task.c"

#include "cwfloppy.h"
//#include "mk4_firmware.h"

#include "encoder-common.h" 
#include "encoder-common.c"

struct cw_drive_struct;

void msdos_encode(struct cwDevUnit *d);
int msdos_decode(struct cwDevUnit *d, int tryNumber);

struct cw_codec cw_codec_msdos = 
{
    msdos_decode,
    msdos_encode
};

void amiga_encode(struct cwDevUnit *d);
int amiga_decode(struct cwDevUnit *d, int tryNumber);

struct cw_codec cw_codec_amiga = 
{
    amiga_decode,
    amiga_encode
};

#include "codec-msdos.c"
#include "codec-amiga.c"

#include "ami_catweasel.c"
#include "ami_probe.h"

#include "dev_cmd.h"

// struct cw_driver *LibInit (struct cw_driver *md, APTR seglist, struct Interface *ISys);
#if defined(AROS)
#else
struct Library *LibInit (struct cw_driver *md, APTR seglist, struct Interface *ISys);
LONG libOpen(struct DeviceManagerInterface *self, struct IORequest *ioreq, ULONG unit_number, ULONG flags);
LONG libClose(struct DeviceManagerInterface *self, struct IORequest *ioreq);
LONG libAbortIO(struct DeviceManagerInterface *self, struct IORequest *ioreq);
LONG libBeginIO(struct DeviceManagerInterface *self, struct IORequest *ioreq);
LONG libExpunge(struct DeviceManagerInterface *self, struct IORequest *ioreq);

STATIC LONG _manager_Obtain(struct DeviceManagerInterface *self) 
{
    return self -> Data.RefCount ++ ;
}

STATIC LONG _manager_Release(struct DeviceManagerInterface *self)
{
    return self -> Data.RefCount -- ;
}

STATIC CONST APTR lib_manager_vectors[] __attribute((used)) =
{
    (APTR)  _manager_Obtain,
    (APTR)  _manager_Release,
    NULL,
    NULL,
    (APTR)  libOpen,
    (APTR)  libClose,
    (APTR)  libExpunge,
    NULL,
    (APTR)  libBeginIO,
    (APTR)  libAbortIO,
    (APTR)  -1
};

STATIC CONST struct TagItem lib_managerTags[] __attribute((used)) =
{
    { MIT_Name,     (Tag) "__device"},
    { MIT_VectorTable,  (Tag) lib_manager_vectors },
    { MIT_Version,      1 },
    { TAG_DONE,     0 }
};

STATIC CONST CONST_APTR LibInterfaces[] __attribute((used)) =
{
    lib_managerTags,
    NULL
};

STATIC CONST struct TagItem libCreateTags[]  __attribute((used)) =
{
    {   CLT_DataSize,       sizeof(struct cw_driver)    },
    {   CLT_InitFunc,       (Tag) LibInit           },
    {   CLT_Interfaces, (Tag) LibInterfaces     },
/*  {   CLT_Vector68K,  (Tag) VecTable68K       }, */
    {   TAG_DONE,       0 }
};

/*
STATIC CONST struct Resident lib_res __attribute((used)) =
{
    RTC_MATCHWORD,
    (struct Resident *) &lib_res,
    (APTR) (&lib_res + 1),
    RTF_NATIVE | RTF_AUTOINIT | RTF_AFTERDOS,
    VERSION,
    NT_DEVICE,
    0,
    DEVICE_NAME,
    VERSION_STR,
    (APTR) LibCreateTags
};
*/

STATIC CONST struct Resident lib_res
#ifdef __GNUC__
__attribute__((used))
#endif
=
{
    RTC_MATCHWORD,
    (struct Resident *)&lib_res,
    (APTR)(&lib_res + 1),
    RTF_NATIVE|RTF_AUTOINIT, /* Add RTF_COLDSTART if you want to be resident */
    VERSION,
    NT_DEVICE, /* Make this NT_DEVICE if needed */
    0, /* PRI, usually not needed unless you're resident */
    DEVICE_NAME,
    VERSION_STR,
    (APTR) libCreateTags
};

void __start()
{
}

// If you don't put in a main, you can't remove -nostartfiles from the compilation. You need to remove -nostartfiles to
// get the IExec and IDOS interfaces automatically.
int main( int argc, char *argv[] )
{
    printf( "This is a device! Don't run me!\n" );
#if defined(AROS)
#else
//    IExec->
#endif    
//    DebugPrintF( "This is debug text from cw.device!\n" );
}
#endif // !AROS

// After lots of crashes I needed this!!!

void InitUnit (int unit_number, struct cwDevUnit *cw_unit, ULONG flags )
{
    cw_unit -> cw_unit_num      = unit_number;
    cw_unit -> format           = flags;
    cw_unit -> timeout          = 5;
    cw_unit->needsUpdate = 0;
    cw_unit->motorChanged = 0;

    write_txt( cw_unit->driver->debug_port, "Allocating drive geometry." );

    if (cw_unit -> drive_geo = 
    EXEC_CALL AllocVec(sizeof(struct DriveGeometry), MEMF_CLEAR 
#if defined(AROS)    
#else
    | MEMF_SHARED
#endif    
     ))
    {
        cw_unit -> drive_geo ->dg_SectorSize        =   cw_formats[ cw_unit -> format ].blksize;
        cw_unit -> drive_geo ->dg_Cylinders     =   cw_formats[ cw_unit -> format ].cylinders;
        cw_unit -> drive_geo ->dg_Heads         =   cw_formats[ cw_unit -> format ].heads;
        cw_unit -> drive_geo ->dg_TrackSectors  =   cw_formats[ cw_unit -> format ].max_secs_per_track;

        cw_unit -> drive_geo ->dg_CylSectors        =   cw_unit -> drive_geo ->dg_TrackSectors * cw_unit -> drive_geo ->dg_Heads ;
        cw_unit -> drive_geo ->dg_TotalSectors  =   cw_unit -> drive_geo ->dg_Cylinders * cw_unit -> drive_geo ->dg_CylSectors;

#if defined(AROS)
        cw_unit -> drive_geo ->dg_BufMemType    =   MEMF_PUBLIC;
#else
        cw_unit -> drive_geo ->dg_BufMemType    =   MEMF_SHARED;
#endif
        cw_unit -> drive_geo ->dg_DeviceType        =   DRIVE3_5;
        cw_unit -> drive_geo ->dg_Flags         =   DGF_REMOVABLE;
        cw_unit -> drive_geo ->dg_Reserved      =   0;
    }

    if ( flags == 2 || flags == 3 ) // MS-DOS
        codec_msdos_init();
}

pci_device_id id_table[] = {
    /* MK3 */
    { CW_VENDOR, CW_DEVICE, CW_MK3_SUBVENDOR, CW_MK3_SUBDEVICE, &cwfloppy_probe_mk3 },

    /* The MK4 PCI bridge has a bug where the reported device IDs
     * may randomly change between several values. */

    { CW_VENDOR, CW_DEVICE, CW_MK4_SUBVENDOR1, CW_MK4_SUBDEVICE1, &cwfloppy_probe_mk4 },
    { CW_VENDOR, CW_DEVICE, CW_MK4_SUBVENDOR1, CW_MK4_SUBDEVICE2, &cwfloppy_probe_mk4 },
    { CW_VENDOR, CW_DEVICE, CW_MK4_SUBVENDOR2, CW_MK4_SUBDEVICE1, &cwfloppy_probe_mk4 },
    { CW_VENDOR, CW_DEVICE, CW_MK4_SUBVENDOR2, CW_MK4_SUBDEVICE2, &cwfloppy_probe_mk4 },
    { 0, }
};

#if defined(AROS)
struct LegacyBusStruct
{
    struct Node     mNode;
    IPTR            mIOBase;
    IPTR            mIOAlt;
    IPTR            mINTLine;
    IPTR            mDMABase;
    UBYTE           mControllerID;
    UBYTE           mBusID;
};

static struct LegacyBusPrototypeStruct
{
    ULONG lb_Port;
    ULONG lb_Alt;
    UBYTE lb_IRQ;
    UBYTE lb_ControllerID;
    UBYTE lb_Bus;
} gLegacyBuses[] =
{
    {0x1f0, 0x3f4, 14, 0, 0},
    {0x170, 0x374, 15, 0, 1},
    {0x168, 0x36c, 10, 1, 0},
    {0x1e8, 0x3ec, 11, 1, 1},
    {0, 0, 0, 0, 0},
};

typedef struct
{
    struct cw_driver *mDriver;
    UWORD mCurrentBus;
} EnumeratorArgs;

static
AROS_UFH3(void, PCIEnumeratorHook,
    AROS_UFHA(struct Hook *, hook, A0),
    AROS_UFHA(OOP_Object *, Device, A2),
    AROS_UFHA(APTR, message, A1))
{
    AROS_USERFUNC_INIT
    
    IPTR    ProductID, VendorID, DMABase, DMASize,
            INTLine, IOBase, IOAlt, IOSize, AltSize,
            SubClass, Interface;
            
    BOOL tUsableBus = FALSE;

    static int index = 0;
    
    OOP_AttrBase HiddPCIDeviceAttrBase = OOP_ObtainAttrBase(IID_Hidd_PCIDevice);
    
    EnumeratorArgs *tArgs = (EnumeratorArgs*)hook->h_Data;
    struct cw_driver *driver = tArgs->mDriver;
    
    OOP_GetAttr(Device, aHidd_PCIDevice_VendorID, &VendorID);
    OOP_GetAttr(Device, aHidd_PCIDevice_ProductID, &ProductID);
    OOP_GetAttr(Device, aHidd_PCIDevice_Base4, &DMABase);
    OOP_GetAttr(Device, aHidd_PCIDevice_Size4, &DMASize);
    OOP_GetAttr(Device, aHidd_PCIDevice_SubClass, &SubClass);
    OOP_GetAttr(Device, aHidd_PCIDevice_Interface, &Interface);
    
    if ( VendorID == CW_VENDOR && ProductID == CW_DEVICE )
//    if ( VendorID == 0x1022 && ProductID == 0x2000 )
    {
        write_hex( driver->debug_port, "Found device! Vendor: ", VendorID );
        write_hex( driver->debug_port, "Product: ", ProductID );
        write_hex( driver->debug_port, "DMA address: ", DMABase );
        write_hex( driver->debug_port, "DMA size: ", DMASize );
        write_hex( driver->debug_port, "Device address: ", (ULONG)Device );
   
        APTR tDeviceBase = NULL, tFoundBase = NULL;
   
//        for ( int tDeviceNumber = 0 ; tDeviceNumber < 6 ; tDeviceNumber++ )
        {
            ULONG tIsMem = 0;
            
            OOP_GetAttr(Device, aHidd_PCIDevice_Type0, &tIsMem);
            OOP_GetAttr(Device, aHidd_PCIDevice_Base0, &tDeviceBase );
            if (tIsMem == 0 && tDeviceBase > 0 )
                tFoundBase = tDeviceBase;
            OOP_GetAttr(Device, aHidd_PCIDevice_Type1, &tIsMem);
            OOP_GetAttr(Device, aHidd_PCIDevice_Base1, &tDeviceBase );
            if (tIsMem == 0 && tDeviceBase > 0 )
                tFoundBase = tDeviceBase;
            OOP_GetAttr(Device, aHidd_PCIDevice_Type2, &tIsMem);
            OOP_GetAttr(Device, aHidd_PCIDevice_Base2, &tDeviceBase );
            if (tIsMem == 0 && tDeviceBase > 0 )
                tFoundBase = tDeviceBase;
            OOP_GetAttr(Device, aHidd_PCIDevice_Type3, &tIsMem);
            OOP_GetAttr(Device, aHidd_PCIDevice_Base3, &tDeviceBase );
            if (tIsMem == 0 && tDeviceBase > 0 )
                tFoundBase = tDeviceBase;
            OOP_GetAttr(Device, aHidd_PCIDevice_Type4, &tIsMem);
            OOP_GetAttr(Device, aHidd_PCIDevice_Base4, &tDeviceBase );
            if (tIsMem == 0 && tDeviceBase > 0 )
                tFoundBase = tDeviceBase;
            OOP_GetAttr(Device, aHidd_PCIDevice_Type5, &tIsMem);
            OOP_GetAttr(Device, aHidd_PCIDevice_Base5, &tDeviceBase );
            if (tIsMem == 0 && tDeviceBase > 0 )
                tFoundBase = tDeviceBase;
        }
   
        driver -> controller[index] =                        
            EXEC_CALL AllocVec(sizeof(struct catweasel_contr),MEMF_CLEAR | MEMF_PUBLIC );

        struct PCIDevice *tDevice = AllocVec( sizeof(struct PCIDevice), MEMF_CLEAR | MEMF_PUBLIC );
        tDevice->mVendor = VendorID;
        tDevice->mProductID = ProductID;
        tDevice->mDMABase = (IPTR)tFoundBase;
        tDevice->mDMASize = DMASize;
        tDevice->mObject = Device;

        if (driver -> controller[index])
        {
            driver -> controller[index] -> pcicard  = tDevice;
            driver -> controller[index] -> io_range = (void *)tDevice->mDMASize;
            driver -> controller[index] -> io_base  = tDevice->mDMABase;
            driver -> controller[index] -> driver   = driver;
            driver->controller[ index ]->mDiskChanged[ 0 ] = -1;
            driver->controller[ index ]->mDiskChanged[ 1 ] = -1;

            cwfloppy_probe_mk4( driver, 0 );
            catweasel_init_controller( driver -> controller[index] );

            index++;
            driver -> num_controllers = index;
        }
    }
        
    OOP_ReleaseAttrBase(IID_Hidd_PCIDevice);
    
    AROS_USERFUNC_EXIT
} 

void ScanPCI(struct cw_driver *driver)
{
    OOP_Object *tPCI;
    
    EnumeratorArgs Args =
    {
        driver,
        0
    };
    
    tPCI = (OOP_Object *)OOP_NewObject(NULL, CLID_Hidd_PCI, NULL );
    
    if ( tPCI )
    {
        write_txt( driver->debug_port, "Found PCI bus!" );
        
        struct Hook FindHook = {
            h_Entry:    (IPTR (*)())PCIEnumeratorHook,
            h_Data:     &Args
            };
            
        struct TagItem Requirements[] = {
        {tHidd_PCI_Class,   0x00},
        {TAG_DONE,          0x00}
        };
        
        struct pHidd_PCI_EnumDevices enummsg = {
            mID:    OOP_GetMethodID(IID_Hidd_PCI, moHidd_PCI_EnumDevices),
            callback: &FindHook,
            requirements:   NULL/*(struct TagItem *)&Requirements*/,
            }, *msg = &enummsg;
            
        OOP_DoMethod(tPCI, (OOP_Msg)msg);
        OOP_DisposeObject(tPCI);
    }
}

int find_io_cards(struct cw_driver *driver)
{
    int i;
    struct LegacyBusStruct *tLegacyBus;
    driver->num_units = 0;
    write_txt( driver->debug_port, "Enumerating PCI buses..." );

    NEWLIST((struct List *)&driver->mLegacyBuses);
    NEWLIST((struct List *)&driver->mProbedBuses);

    for ( i=0 ; gLegacyBuses[ i ].lb_Port != 0 ; i++ )
    {
        if ( (tLegacyBus = AllocVec(sizeof(struct LegacyBusStruct), MEMF_CLEAR | MEMF_PUBLIC)) != NULL )
        {
            write_num( driver->debug_port, "Prepare legacy bus at id ", i );
            
            tLegacyBus->mIOBase = (IPTR)gLegacyBuses[ i ].lb_Port;
            tLegacyBus->mIOAlt = (IPTR)gLegacyBuses[ i ].lb_Alt;
            tLegacyBus->mINTLine = (IPTR)gLegacyBuses[ i ].lb_IRQ;
            tLegacyBus->mControllerID = (IPTR)gLegacyBuses[ i ].lb_ControllerID;
            tLegacyBus->mBusID = (IPTR)gLegacyBuses[ i ].lb_Bus;
            AddTail(&driver->mLegacyBuses, &tLegacyBus->mNode );
        } 
    }

    write_txt( driver->debug_port, "Initialising BUS list...\n");
    driver->mBuses.mlh_Head = (struct MinNode*) &driver->mBuses.mlh_Tail;
    driver->mBuses.mlh_Tail = NULL;
    driver->mBuses.mlh_TailPred = (struct MinNode *)&driver->mBuses.mlh_Head;
    
    write_txt( driver->debug_port, "Scanning buses..." );
    
    ScanPCI( driver );

    write_txt( driver->debug_port, "Done enumerating PCI buses.\n" );

    return 1;   // error
}
#else

int find_io_cards(struct cw_driver *driver) 
{
    int                     i,ii;
    int                     index=0;
    int                     err = 1;
    struct PCIDevice            *tmp_device;
    struct PCIResourceRange *pci_range;

    if (!driver -> I_PCI) return err;


    for (i = 0; id_table[i].vendor != 0;i++ )
    {
        //write_txt(driver -> debug_port,"FindDeviceTags()\n");

        if (tmp_device = (void *) 
        driver -> I_PCI-> FindDeviceTags(
            FDT_VendorID,   id_table[i].vendor, 
            FDT_DeviceID,       id_table[i].device,
            FDT_Index,      index,
            TAG_DONE))
        {

            //write_txt(driver -> debug_port,"ReadConfigWord()\n");

            if (tmp_device -> ReadConfigWord ( PCI_SUBSYSTEM_VENDOR_ID ) == id_table[i].subvendor)
            {
                for (ii = 0; ii < 6; ii++) 
                {
                    //write_txt(driver -> debug_port,"GetResourceRange()\n");

                    if (pci_range = tmp_device -> GetResourceRange(ii))
                    {
                        if (pci_range -> Flags & PCI_RANGE_IO)
                        {
                            driver -> controller[index] =                        
                            EXEC_CALL AllocVec(sizeof(struct catweasel_contr),MEMF_CLEAR | MEMF_SHARED );

                            if (driver -> controller[index])
                            {
                                tmp_device -> Obtain();

                                driver -> controller[index] -> pcicard  = tmp_device;
                                driver -> controller[index] -> io_range = pci_range;
                                driver -> controller[index] -> io_base  = pci_range -> BaseAddress;
                                driver -> controller[index] -> driver   = driver;
                                driver->controller[ index ]->mDiskChanged[ 0 ] = -1;
                                driver->controller[ index ]->mDiskChanged[ 1 ] = -1;

                                id_table[i].probe( driver, index );

                                catweasel_init_controller( driver -> controller[index] );

                                index++;
                                driver -> num_controllers = index;
                                err = 0;
                            }
                            else
                            {
                                // free any range i don't need
                                tmp_device -> FreeResourceRange(pci_range);
                            }
                        }
                        else
                        {
                            // free any range i don't need
                            tmp_device -> FreeResourceRange(pci_range);
                        }
                    }
                }
            }
        }
    }

    return err; 
}
#endif

#if defined(AROS)
static int GM_UNIQUENAME(Init)( struct cw_driver *md, APTR seglist )
#else
struct Library *LibInit (struct cw_driver *md, APTR seglist, struct Interface *ISys) 
#endif
{
    struct Library      *lib = &md -> cw_device.dd_Library;

    lib -> lib_Node.ln_Type = NT_DEVICE;
    lib -> lib_Node.ln_Pri  = 0;
    lib -> lib_Node.ln_Name = (char *)DEVICE_NAME;
    lib -> lib_Flags        = LIBF_SUMUSED|LIBF_CHANGED;
    lib -> lib_Version      = VERSION;
    lib -> lib_Revision     = REVISION;
    lib -> lib_IdString     = VERSION_STR;

    md -> debug_port = 0;
    md -> num_controllers = 0;
    md -> num_units = 0;

    if (seglist)
    {
        md -> SegList   = (BPTR) seglist;
    }
#if defined(AROS)
#else
    IExec = md -> I_Exec = ((struct ExecIFace *)((*(struct ExecBase **)4)->MainInterface));
#endif

#if defined(AROS)
    OpenLibrary( "dos.library", 41);
    OpenLibrary( "expansion.library", 41);    
#else
    if (!md -> DOSBase) md -> DOSBase = EXEC_CALL OpenLibrary("dos.library",50);
    if (!md -> ExpBase) md -> ExpBase = EXEC_CALL OpenLibrary("expansion.library",50);
    if (!md -> I_DOS)
    {
        if (md -> I_DOS = (void *) EXEC_CALL GetInterface(md -> DOSBase,"main",1L,NULL))
        {

            IDOS = md -> I_DOS;
        }
    }
#endif

    md -> debug_port = EXEC_CALL FindPort( DEBUG_NAME );

#if defined(AROS)
#else
    if (md -> ExpBase)
    {
        if (!md -> I_Exp) md -> I_Exp = (void *) EXEC_CALL GetInterface(md -> ExpBase,"main",1L,NULL);
        if (!md -> I_PCI) md -> I_PCI = (void *) EXEC_CALL GetInterface(md -> ExpBase,"pci",1L,NULL );
    }
#endif
    
#if defined(AROS)
    return TRUE;
#else
    return  (struct Library *) md;
#endif
}

#if defined(AROS)
struct catweasel_contr *sharedController;

LONG __libOpen_light( struct cw_driver *md, ULONG unit_number, ULONG flags )
#else
LONG __libOpen_light( struct DeviceManagerInterface *self, ULONG unit_number, ULONG flags )
#endif
{
    int             i = 0;
    int             error = 0;
#if !defined(AROS)
    struct cw_driver    *md = (struct cw_driver *) self -> Data.LibBase;
#endif
    struct Library      *lib = &md -> cw_device.dd_Library;

#if defined(AROS)
#else
    IExec = ((struct ExecIFace *)((*(struct ExecBase **)4)->MainInterface));

// open libs
    if (!md -> I_Exec) LibInit (md, 0, (void *) IExec);
    if (!md -> I_Exec) goto fail;
#endif

// find controllers
    if ( lib->lib_OpenCnt == 1 )
    {
        if ( md -> num_controllers == 0 )
        {
            write_txt( md->debug_port, "Finding IO cards...\n" );
            find_io_cards(md);
            md -> num_units = md -> num_controllers * 2;

            if ( md -> num_controllers == 0 )
            {
                write_txt( md->debug_port, "No controllers found.\n" );
                goto fail;
            }
            write_num( md -> debug_port, (char *)"num controllers:", md -> num_controllers );
            write_num( md -> debug_port, (char *)"num units:", md -> num_units );
            write_txt( md->debug_port, (char *)"clearing all units." );
            for( i=0 ; i < md->num_units ; i+=2 )
            {
                int tUnit;
                for ( tUnit = 0 ; tUnit < 2 * NUMBER_OF_SUPPORTED_FORMATS ; tUnit++ )
                    md->controller[ i/2 ]->cw_unit[ tUnit ] = NULL;
            }
            write_hex( md->debug_port, "Controller 0 address:", md->controller[ 0 ]->pcicard->mDMABase );
        }

        for ( i=0 ; i<md -> num_controllers ; i++ )
        {
            write_num( md->debug_port, (char *)"starting task for controller", i );
            
#if defined(AROS)
            sharedController = md->controller[ i ];
            if (md -> controller[i] -> cw_task = CreateTask( DEVICE_NAME, 0, (APTR) task_begin, 80000))
#else            
            if (md -> controller[i] -> cw_task =  EXEC_CALL CreateTaskTags(
                    DEVICE_NAME, 
                    0, 
                    (APTR) task_begin, 
                    80000, 
                AT_Param1, (ULONG) md -> controller[i], 
                TAG_END))
#endif
            {
                write_txt( md->debug_port, (char *)"Creating msgport.\n" );
#if defined(AROS)
#else
                EXEC_CALL NewList(&md -> controller[i] -> MsgPort.mp_MsgList);
//                md->controller[i]->MsgPort.mp_MsgList.Add( CreatePort(NULL, 0) );
#endif
                md -> controller[i] -> MsgPort = EXEC_CALL CreateMsgPort();
                md -> controller[i] -> MsgPort->mp_Flags = PA_SIGNAL;
                md -> controller[i] -> MsgPort->mp_SigBit = 0;
            }
        }
    }

    write_hex( md->debug_port, (char *)"Checking controller unit for controller", (int)md->controller[ unit_number/2 ] );
    write_num( md->debug_port, (char *)"unit number", unit_number );
    write_num( md->debug_port, (char *)"flags", flags );
    write_hex( md->debug_port, (char *)"unit address",  (int)md->controller[ unit_number/2 ]->cw_unit[ (unit_number&1) + flags * 2 ] );
    if ( md->controller[ unit_number/2 ]->cw_unit[ (unit_number&1) + flags * 2 ] == NULL )
    {
        write_num( md->debug_port, (char *)"Creating unit for number", (unit_number&1) + flags * 2 );
        md->controller[ unit_number/2 ]->cw_unit[ (unit_number&1) + flags * 2 ] =
        EXEC_CALL AllocVec( sizeof( struct cwDevUnit ), 
#if defined(AROS)
#else        
        MEMF_PRIVATE | 
#endif        
        MEMF_CLEAR );
        write_hex( md->debug_port, (char *)"Allocated. Now initing ", (int)md->controller[ unit_number/2 ]->cw_unit[ (unit_number&1) + flags*2 ]  );
        md->controller[ unit_number/2 ]->cw_unit[ (unit_number&1) + flags * 2 ]->controller = md->controller[ unit_number/2 ];
        md->controller[ unit_number/2 ]->cw_unit[ (unit_number&1) + flags * 2 ]->driver = md;
        InitUnit( unit_number, md->controller[ unit_number/2 ]->cw_unit[ (unit_number&1) + flags*2 ], flags );
        write_txt( md->debug_port, (char *)"Inited." );
        write_num( md->debug_port , (char *)"\nInit unit: ", (unit_number&1) + flags*2 );
        write_hex( md->debug_port, (char *)"unit adr:" , (int)md->controller[ unit_number/2 ]->cw_unit[ (unit_number&1) + flags * 2 ] );
    }

    write_txt( md->debug_port, "LibOpenLight success.\n" );
    return 0;

fail:
    write_txt( md->debug_port, "LibOpenLight fail.\n" );
    return error;
}


#if defined(AROS)
static int GM_UNIQUENAME(Open)( LIBBASETYPEPTR cwb, struct IOExtTD *iotd, ULONG unit_number, ULONG flags )
#else
LONG libOpen(struct DeviceManagerInterface *self, struct IORequest *ioreq, ULONG unit_number, ULONG flags) 
#endif
{
#if defined(AROS)
    struct cw_driver    *driver = (struct cw_driver *) cwb;
    struct IORequest    *ioreq  = (struct IORequest *)&iotd->iotd_Req;
#else
    struct cw_driver    *driver = (struct cw_driver *) self -> Data.LibBase;
#endif
    int             i = 0;
    int             error = 0;
    struct Library      *lib = &driver -> cw_device.dd_Library;

    // Done on the start to prevent Expunge() function from closing device
    lib->lib_OpenCnt++;

    write_hex( driver->debug_port, "Opening catweasel.device with flags ", flags );

#if defined(AROS)
    error = __libOpen_light( driver, unit_number, flags );
#else
    error = __libOpen_light( self, unit_number, flags );
#endif
    if (error) goto fail;

    /* see if the unit number is in range */
    if(unit_number >= driver -> num_units)
    {
        /* unit number out of range */
        write_txt( driver -> debug_port, "Unit number out of range." );
        error = IOERR_OPENFAIL;
        goto fail;
    }

    write_hex( driver -> debug_port , (char *)"open unit no",unit_number);

    lib->lib_Flags &= ~ LIBF_DELEXP;
    ioreq->io_Error = 0;
    ioreq->io_Message.mn_Node.ln_Type = NT_REPLYMSG;
    ioreq->io_Unit = (struct Unit *)driver->controller[ unit_number/2 ]->cw_unit[ (unit_number & 1) + flags * 2 ];
    write_hex( driver->debug_port, (char *)"IO units now set to", (int)ioreq->io_Unit );
#if defined(AROS)
    return TRUE;
#else
    return 0;
#endif

fail:
    // if it fails the open is cancelled
    lib -> lib_OpenCnt--;   
    write_txt( driver->debug_port, "Driver failed to open.\n" );
#if defined(AROS)
    return FALSE;
#else
    return error;
#endif
}

#if defined(AROS)
static int GM_UNIQUENAME(Close) ( LIBBASETYPEPTR cwb, struct IOExtTD *iotd )
#else
LONG libClose(struct DeviceManagerInterface *self, struct IORequest *ioreq)
#endif
{
#if defined(AROS)
    struct cw_driver *md = (struct cw_driver *) cwb;
#else
    struct cw_driver *md = (struct cw_driver *) self -> Data.LibBase;
#endif
    struct Library      *lib = &md -> cw_device.dd_Library;
    struct cwDevUnit    *dev = NULL;
#if defined(AROS)
    struct IORequest *ioreq = (struct IORequest *)&iotd->iotd_Req;   
#endif

    
#if defined(AROS)
#else
    IExec = ((struct ExecIFace *)((*(struct ExecBase **)4)->MainInterface));
#endif
    write_txt( md->debug_port, "Closing catweasel.device.\n" );
    
    if (lib -> lib_OpenCnt) lib -> lib_OpenCnt--;

    if (dev = (struct cwDevUnit *) ioreq -> io_Unit)
    {
//      if (dev -> cw_unit.unit_OpenCnt) dev -> cw_unit.unit_OpenCnt--;
    }

    ioreq -> io_Error                   = 0;
    ioreq -> io_Message.mn_Node.ln_Type = NT_REPLYMSG;

    write_num( md->debug_port, "lib_OpenCnt is now ", lib->lib_OpenCnt );

#if defined(AROS)
    if ( lib->lib_OpenCnt == 1 )
        lib->lib_OpenCnt = 0;   // Force shutdown of the task and remove the task's reference to the device.
#endif

    if ( lib->lib_OpenCnt == 0 )
    {
        int i;
        for ( i=0 ; i<md -> num_controllers ; i++ )
        {
            if ( md->controller[ i ] )
            {
                md->controller[ i ]->mShutDownNow = 1;
                write_txt( md->debug_port, (char *)"Setting shut down flag..." );
//                while ( md->controller[ i ]->mShutDownNow == 1 )
//                    cw_msdelay( md->controller[ i ]->ms_timer, 500 );
                    DOS_CALL Delay( 150 );
                write_txt( md->debug_port, "Task has aborted." );
                
                DeleteMsgPort( md->controller[ i ]->MsgPort );
            }
        }
        // Closedown!
        write_txt( md->debug_port, (char *)"freeing all allocated units." );
        for( i=0 ; i < md->num_units ; i++ )
        {
            int tUnit;
            for ( tUnit = 0 ; tUnit < 2 * NUMBER_OF_SUPPORTED_FORMATS ; tUnit++ )
                if ( md->controller[ i/2 ]->cw_unit[ tUnit ] )
                {
//                    if ( md->controller[ i/2 ]->cw_unit[ tUnit ]->motorChanged == 1 )
//                        cw_msdelay( md->controller->ms_timer, 500);
                    EXEC_CALL FreeVec( md->controller[ i/2 ]->cw_unit[ tUnit ] );
                    md->controller[ i/2 ]->cw_unit[ tUnit ] = NULL;
                }
        }
    }

    return 0;
}

#if defined(AROS)
AROS_LH1( LONG, abortio,
    AROS_LHA(struct IOExtTD *, iotd, A1),
    struct CatweaselBase *, cwb, 6, Catweasel )
#else
LONG libAbortIO(struct DeviceManagerInterface *self, struct IORequest *ioreq) 
#endif
{
#if defined(AROS)
    AROS_LIBFUNC_INIT

    struct cw_driver *md = (struct cw_driver *)cwb;
    struct IORequest *ioreq = (struct IORequest *)&iotd->iotd_Req;
#else
    struct cw_driver *md = (struct cw_driver *) self -> Data.LibBase;
#endif
    struct Library      *lib = &md -> cw_device.dd_Library;
    struct IOExtTD  *diskreq =(struct IOExtTD *) ioreq ;

#if defined(AROS)
#else
    IExec = ((struct ExecIFace *)((*(struct ExecBase **)4)->MainInterface));

    if ((md -> I_DOS)&&(md->debug_port))
    {
        write_num(  md -> debug_port , (char *)"AbortIO" , diskreq->iotd_Req.io_Command     );
    }
#endif

    ioreq -> io_Error                   = 0;
    ioreq -> io_Message.mn_Node.ln_Type = NT_REPLYMSG;
    return 0;

#if defined(AROS)
    AROS_LIBFUNC_EXIT
#endif
}

#if defined(AROS)
AROS_LH1(void, beginio,
    AROS_LHA(struct IOExtTD *, iotd, A1),
    struct CatweaselBase *, cwb, 5, Catweasel )
#else
LONG libBeginIO(struct DeviceManagerInterface *self, struct IORequest *ioreq) 
#endif
{
#if defined(AROS)
    AROS_LIBFUNC_INIT
    struct cw_driver    *driver = (struct cw_driver *)cwb;
    struct IORequest    *ioreq  = (struct IORequest *)&iotd->iotd_Req;
#else
    struct cw_driver    *driver = (struct cw_driver *) self -> Data.LibBase;
#endif
    struct IOExtTD  *diskreq    = (struct IOExtTD *) ioreq ;
    struct cwDevUnit    *unit;
    int             error;

    write_hex( driver->debug_port, (char *)"Received IORequest ", diskreq->iotd_Req.io_Command );

    if (unit  = (struct cwDevUnit *) ioreq -> io_Unit)
    {
        // Don't really care about multi treded IO, we only have one floppy controller and can do nothing about that..
        // all IO request are qued.


        write_hex( driver->debug_port, (char *)"unit hex no ", (long)unit);

        if (unit -> controller)
        {
#if defined(AROS)
#else
            driver -> I_Exec ->
#endif            
//            Disable();
            ioreq -> io_Message.mn_Node.ln_Type = NT_MESSAGE;   
            ioreq -> io_Flags &= ~IOF_QUICK;
#if defined(AROS)
#else
            driver -> I_Exec -> 
#endif            
            PutMsg( unit -> controller -> MsgPort , (struct Message *) ioreq );

#if defined(AROS)
#else
            driver -> I_Exec -> 
#endif            
//            Enable();
//            ioreq->io_Error = 1;
        }
        else
        {
            write_txt( driver -> debug_port , (char *)"unit has no controller?! \n");
        }

        write_txt( driver->debug_port, "Waiting for completion.\n" );
        if (diskreq->iotd_Req.io_Command != TD_ADDCHANGEINT)
        {
            // Wait for reply....
#if defined(AROS)
            while(ioreq -> io_Message.mn_Node.ln_Type != NT_REPLYMSG) { Delay(1); };
#else
            while(ioreq -> io_Message.mn_Node.ln_Type != NT_REPLYMSG) { driver -> DOS_CALL Delay(1); };
#endif
            write_hex( driver -> debug_port, "IO CMD DONE, return code ", diskreq->iotd_Req.io_Error);
        }
    }

    write_txt( driver->debug_port, (char *)"Done request.\n" );
    
#if defined(AROS)
    return;

    AROS_LIBFUNC_EXIT
#else
    return 0;
#endif
}
// Simple Expunge function, will never try to remove the device!!

#if defined(AROS)
#else
LONG libExpunge( struct DeviceManagerInterface *self , struct IORequest *ioreq ) 
{
    struct cw_driver *md = (struct cw_driver *) self -> Data.LibBase;
    md->cw_device.dd_Library.lib_Flags != LIBF_DELEXP;

    ioreq -> io_Error = 0;
    ioreq -> io_Message.mn_Node.ln_Type = NT_REPLYMSG;
    return 0;
}
#endif


#if defined(AROS)
ADD2INITLIB(GM_UNIQUENAME(Init), 0)
ADD2OPENDEV(GM_UNIQUENAME(Open), 0)
ADD2CLOSEDEV(GM_UNIQUENAME(Close),0)
#endif
