
/*
 * Catweasel -- Advanced Floppy Controller
 * Linux device driver (header)
 *
 * Copyright (C) 1998-2002 Michael Krause
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef _CWFLOPPY_H
#define _CWFLOPPY_H

#ifdef linux
#include <linux/ioctl.h>
#endif

#include "catweasel.h"

#define ENCODE_CALC_WRITETIME 0

/* Change this if you want */

#define CWFLOPPY_MAJOR 120

/*
 * Disk geometry description
 */

struct cwfloppy_format {
    const char name[32];
    int blksize;               /* block size in bytes */
    int numblocks;             /* number of blocks on the disk */

    unsigned char max_secs_per_track;    /* e.g. 21 for 1541 disks */
    unsigned char heads;
    unsigned char cylinders;
    unsigned char readonly;

    int clock; /* 0 = 28MHz, 1 = 14MHz */
    int readtime; /* one rotation of the disk plus duration of one sector */
    int writetime; /* about exactly one rotation of the disk
		      -1 => write data synchronized to index pulse */

    struct cw_codec *codec;
};

#define CWGETPRM _IOR(2, 0x04, struct cwfloppy_format)
#define CWFMTBEG _IO(2, 0x47)
#define	CWFMTTRK _IO(2, 0x48)
#define CWFMTEND _IO(2, 0x49)

#define FD_FILL_BYTE 0xF6 /* format fill byte. */

#ifdef __KERNEL__

#ifdef linux
#include <linux/version.h>
#if LINUX_VERSION_CODE < 0x020100

#include <linux/stddef.h>
#include <linux/timer.h>
#include <linux/kdev_t.h>
#endif

#endif

/*
 * Some macros for the kernel module
 */

#define MAJOR_NR CWFLOPPY_MAJOR

#define DEVICE_REQUEST do_cw_request
#define DEVICE_NR(device) (MINOR(device))
#define DEVICE_ON(device)
#define DEVICE_OFF(device)
#define DEVICE_NO_RANDOM
#define TIMEOUT_VALUE (6 * HZ)

/*
 * The structures used by cwfloppy.c
 */

struct cw_controller_struct {
    catweasel_contr c;
    struct cw_drive_struct drives[2];
};

/* cwprivate.o needs these: */
extern const struct cwfloppy_format cw_formats[];
extern void cw_codec_error(int level, const char *fmt, ...);

/* Codec error levels:
   INCOMPATIBLE - an error which seems to indicate a wrong (incompatible)
   low-level disk format (e.g. "no sync found")
   CORRUPTION - the format is readable by this codec but the disk seems to
   have a physical error (e.g. checksum errors).
   DETAIL - a peculiar error which lies deep in the disk format but otherwise
   the disk seems to be okay; in particular these errors only occur when
   header checksums are okay! (e.g. wrong track or sector entries in a
   sector header)
   */
#define CW_ERRLVL_INCOMPATIBLE 0
#define CW_ERRLVL_CORRUPTION   1
#define CW_ERRLVL_DETAIL       2

#endif /* __KERNEL__ */

#endif /* _CWFLOPPY_H */

