#ifndef CATWEASEL_DEVICE_GCC_H
#define CATWEASEL_DEVICE_GCC_H

/*
    Copyright  1995-2009, The AROS Development Team. All rights reserved.
    $Id: catweasel_device_gcc.h 31829 2009-09-26 01:06:26Z neil $
*/

#include <aros/libcall.h>
#include <exec/devices.h>
#include <exec/semaphores.h>
#include <exec/lists.h>
#include <exec/ports.h>
#include <dos/dos.h>

#include "catweasel.h"

struct CatweaselBase
{
    struct cw_driver    device;
    struct SignalSemaphore  sigsem;
    struct MsgPort      port;
    struct MinList      units;
};

struct unit
{
    struct Message      msg;
    struct CatweaselBase         *CatweaselBase;
    STRPTR                      filename;
    ULONG           unitnum;
    ULONG           usecount;
    struct MsgPort      port;
    BPTR            file;
    ULONG           changecount;
    struct MinList      changeints;
};

#endif
